/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptorKey;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;

public class ClassDescriptorKeyTest {
    private static final String NAME_STRING = "name";
    private static final String PACKAGENAME_STRING = "packagename";
    private Classname classname1 = new Classname("name");
    private Classname classname2 = new Classname("name");
    private Packagename packagename1 = Packagename.of("packagename", null);
    private Packagename packagename2 = Packagename.of("packagename", null);
    private IFile file;

    @Before
    public void setup() {
        this.file = (IFile)Mockito.mock(IFile.class);
    }

    @Test
    public void differentClassDescriptorKeysWithEqualContentsAreEqualAndNotSame() {
        ClassDescriptorKey key1a = new ClassDescriptorKey(this.file, this.classname1, this.packagename1);
        ClassDescriptorKey key1b = new ClassDescriptorKey(this.file, this.classname1, this.packagename1);
        ClassDescriptorKey key2 = new ClassDescriptorKey(this.file, this.classname2, this.packagename2);
        Assert.assertEquals((Object)key1a, (Object)key1b);
        Assert.assertEquals((Object)key1a, (Object)key2);
        Assert.assertEquals((Object)key1b, (Object)key2);
        Assert.assertNotSame((Object)key1a, (Object)key1b);
        Assert.assertNotSame((Object)key1a, (Object)key2);
        Assert.assertNotSame((Object)key1b, (Object)key2);
    }
}

