/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.projectusus.c4j.C4JFileWriter;
import org.projectusus.c4j.UsusContractBase;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;

public class ClassDescriptorContract
extends UsusContractBase<ClassDescriptor> {
    private String targetString() {
        return " Meth-Target: " + this.m_target;
    }

    public ClassDescriptorContract(ClassDescriptor target) {
        super(target);
    }

    public void classInvariant() {
        this.assertThat(ClassDescriptor.getAll().contains(this.m_target), "Element is contained in list of all:" + this.targetString());
        for (ClassDescriptor child : ((ClassDescriptor)this.m_target).getChildren()) {
            this.assertThat(child.getParents().contains(this.m_target), "Target is parent of each child" + this.targetString() + " child: " + child);
        }
        for (ClassDescriptor parent : ((ClassDescriptor)this.m_target).getParents()) {
            this.assertThat(parent.getChildren().contains(this.m_target), "Target is child of each parent" + this.targetString() + " parent: " + parent);
        }
    }

    public static void pre_clear() {
    }

    public static void post_clear() {
        C4JFileWriter.assertStatic(ClassDescriptor.getAll().isEmpty(), "Set of all class descriptors is empty");
    }

    public static void pre_getAll() {
    }

    public static void post_getAll() {
        Set cfr_ignored_0 = (Set)ClassDescriptorContract.getReturnValue();
    }

    public static void pre_of(WrappedTypeBinding type) {
        C4JFileWriter.assertStatic(type != null, "type_not_null");
        C4JFileWriter.assertStatic(type.getUnderlyingResource() != null, "Underlying Resource of type must not be null.");
        C4JFileWriter.assertStatic(type.getClassname() != null, "Classname of type must not be null");
        C4JFileWriter.assertStatic(type.getPackagename() != null, "Packagename of type must not be null");
    }

    public static void post_of(WrappedTypeBinding type) {
        ClassDescriptor returnValue = (ClassDescriptor)ClassDescriptorContract.getReturnValue();
        C4JFileWriter.assertStatic(ClassDescriptor.getAll().contains(returnValue), "List of all contains ClassDescriptor " + returnValue);
    }

    public static void pre_of(IFile file, Classname classname, Packagename packagename) {
        C4JFileWriter.assertStatic(file != null, "file_not_null");
        C4JFileWriter.assertStatic(classname != null, "classname_not_null");
        C4JFileWriter.assertStatic(packagename != null, "packagename_not_null");
    }

    public static void post_of(IFile file, Classname classname, Packagename packagename) {
        ClassDescriptor returnValue = (ClassDescriptor)ClassDescriptorContract.getReturnValue();
        C4JFileWriter.assertStatic(ClassDescriptor.getAll().contains(returnValue), "List of all contains ClassDescriptor " + returnValue);
        String classtext = " Class: " + returnValue;
        C4JFileWriter.assertStatic(returnValue.getFile() == file, "Created class is associated with file." + classtext + " File: " + file);
        C4JFileWriter.assertStatic(returnValue.getClassname() == classname, "Created class is associated with classname." + classtext + " Classname: " + classname);
        C4JFileWriter.assertStatic(returnValue.getPackagename() == packagename, "Created class is associated with packagename." + classtext + " Package: " + packagename);
        C4JFileWriter.assertStatic(packagename.containsClass(returnValue), "Package of created class contains this class." + classtext + " Package: " + packagename);
    }

    public void pre_getFile() {
    }

    public void post_getFile() {
        IFile cfr_ignored_0 = (IFile)ClassDescriptorContract.getReturnValue();
    }

    public void pre_getClassname() {
    }

    public void post_getClassname() {
        Classname cfr_ignored_0 = (Classname)ClassDescriptorContract.getReturnValue();
    }

    public void pre_getPackagename() {
    }

    public void post_getPackagename() {
        Packagename cfr_ignored_0 = (Packagename)ClassDescriptorContract.getReturnValue();
    }

    public void pre_qualifiedClassName() {
    }

    public void post_qualifiedClassName() {
        String cfr_ignored_0 = (String)ClassDescriptorContract.getReturnValue();
    }

    public void pre_getChildren() {
    }

    public void post_getChildren() {
        Set returnValue = (Set)ClassDescriptorContract.getReturnValue();
        this.assertThat(!returnValue.contains(this.m_target), "Target is not a child" + this.targetString());
    }

    public void pre_getParents() {
    }

    public void post_getParents() {
        Set returnValue = (Set)ClassDescriptorContract.getReturnValue();
        this.assertThat(!returnValue.contains(this.m_target), "Target is not a parent" + this.targetString());
    }

    public void pre_getChildrenInOtherPackages() {
    }

    public void post_getChildrenInOtherPackages() {
        Set returnValue = (Set)ClassDescriptorContract.getReturnValue();
        this.assertThat(!returnValue.contains(this.m_target), "Target is not a child in another package" + this.targetString());
        for (ClassDescriptor descriptor : returnValue) {
            this.assertThat(!descriptor.getPackagename().equals(((ClassDescriptor)this.m_target).getPackagename()), "Children are not in the same package as target" + this.targetString());
        }
    }

    public void pre_getCCD() {
    }

    public void post_getCCD() {
        ((Integer)ClassDescriptorContract.getReturnValue()).intValue();
    }

    public void pre_getTransitiveParentCount() {
    }

    public void post_getTransitiveParentCount() {
        ((Integer)ClassDescriptorContract.getReturnValue()).intValue();
    }

    public void pre_prepareRemoval() {
    }

    public void post_prepareRemoval() {
        this.assertThat(((ClassDescriptor)this.m_target).getChildren().isEmpty(), "Target is not connected to any children any more" + this.targetString());
        this.assertThat(((ClassDescriptor)this.m_target).getCCD() == 1, "Target's CCD is 1" + this.targetString());
        for (ClassDescriptor child : ClassDescriptor.getAll()) {
            this.assertThat(!child.getParents().contains(this.m_target), "There are no children for target any more" + this.targetString() + " Child: " + child);
        }
    }

    public void pre_removeFromPool() {
        this.post_prepareRemoval();
    }

    public void post_removeFromPool() {
        this.post_prepareRemoval();
        this.assertThat(((ClassDescriptor)this.m_target).getParents().isEmpty(), "Target is not connected to any parents any more" + this.targetString());
        this.assertThat(((ClassDescriptor)this.m_target).getTransitiveParentCount() == 1, "Target's transitive parent count is 1" + this.targetString());
        for (ClassDescriptor parent : ClassDescriptor.getAll()) {
            this.assertThat(!parent.getChildren().contains(this.m_target), "There are no parents for target any more" + this.targetString() + " Parent: " + parent);
        }
    }

    public void pre_addChild(ClassDescriptor target) {
        this.assertThat(target != null, "target_not_null" + this.targetString());
    }

    public void post_addChild(ClassDescriptor target) {
        if (!((ClassDescriptor)this.m_target).equals((Object)target)) {
            this.assertThat(((ClassDescriptor)this.m_target).getChildren().contains(target), "Method argument is now in set of children" + this.targetString());
        }
    }

    public void pre_getParentsInOtherPackages() {
    }

    public void post_getParentsInOtherPackages() {
        Set returnValue = (Set)ClassDescriptorContract.getReturnValue();
        this.assertThat(!returnValue.contains(this.m_target), "Target is not a parent in another package" + this.targetString());
        for (ClassDescriptor descriptor : returnValue) {
            this.assertThat(!descriptor.getPackagename().equals(((ClassDescriptor)this.m_target).getPackagename()), "Parents are not in the same package as target" + this.targetString());
        }
    }
}

