/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import ch.akuhn.foreach.ForEach;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.c4j.ContractReference;
import org.eclipse.core.resources.IFile;
import org.projectusus.core.filerelations.model.ClassDescriptorCleanup;
import org.projectusus.core.filerelations.model.ClassDescriptorKey;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.util.ForEach2;
import org.projectusus.core.util.SelectUnique;

@ContractReference(contractClassName="ClassDescriptorContract")
public class ClassDescriptor {
    private static Map<ClassDescriptorKey, ClassDescriptor> classes = new HashMap<ClassDescriptorKey, ClassDescriptor>();
    protected final Set<ClassDescriptor> parents;
    protected final Set<ClassDescriptor> children;
    private final ClassDescriptorKey key;
    private final Set<ClassDescriptor> transitiveChildrenCache = new HashSet<ClassDescriptor>();

    public static void clear() {
        classes.clear();
    }

    public static Set<ClassDescriptor> getAll() {
        return new HashSet<ClassDescriptor>(classes.values());
    }

    public static ClassDescriptor of(WrappedTypeBinding type) {
        return ClassDescriptor.of(new ClassDescriptorKey(type));
    }

    public static ClassDescriptor of(IFile file, Classname classname, Packagename packagename) {
        return ClassDescriptor.of(new ClassDescriptorKey(file, classname, packagename));
    }

    private static ClassDescriptor of(ClassDescriptorKey key) {
        if (classes.containsKey(key)) {
            return classes.get(key);
        }
        return ClassDescriptor.newClassDescriptor(key);
    }

    private static ClassDescriptor newClassDescriptor(ClassDescriptorKey key) {
        ClassDescriptor newClassDescriptor = new ClassDescriptor(key);
        classes.put(key, newClassDescriptor);
        return newClassDescriptor;
    }

    private static void removeDescriptor(ClassDescriptorKey key) {
        ClassDescriptor descriptor = classes.remove(key);
        if (descriptor != null) {
            descriptor.removeFromPackage();
        }
    }

    private ClassDescriptor(ClassDescriptorKey key) {
        this.key = key;
        this.parents = new HashSet<ClassDescriptor>();
        this.children = new HashSet<ClassDescriptor>();
        key.getPackagename().addClass(this);
    }

    private void removeFromPackage() {
        this.key.getPackagename().removeClass(this);
    }

    public IFile getFile() {
        return this.key.getFile();
    }

    public Classname getClassname() {
        return this.key.getClassname();
    }

    public Packagename getPackagename() {
        return this.key.getPackagename();
    }

    public boolean equals(Object object) {
        return object instanceof ClassDescriptor && this.equals((ClassDescriptor)object);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    private boolean equals(ClassDescriptor other) {
        return this.key.equals((Object)other.key);
    }

    public String toString() {
        return String.valueOf(this.qualifiedClassName()) + "[" + this.key.getFile().getName() + "]";
    }

    public String qualifiedClassName() {
        return this.key.getPackagename() + "." + this.key.getClassname();
    }

    private void clearOwnAndParentsTransitiveChildrenCache() {
        if (this.transitiveChildrenCache.isEmpty()) {
            return;
        }
        this.transitiveChildrenCache.clear();
        for (ClassDescriptor parent : this.parents) {
            parent.clearOwnAndParentsTransitiveChildrenCache();
        }
    }

    public Set<ClassDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public Set<ClassDescriptor> getParents() {
        return Collections.unmodifiableSet(this.parents);
    }

    public Set<ClassDescriptor> getChildrenInOtherPackages() {
        for (SelectUnique target : ForEach2.selectUnique(this.children)) {
            boolean bl = target.yield = !this.getPackagename().equals(((ClassDescriptor)target.value).getPackagename());
        }
        return (Set)ForEach.result();
    }

    public Set<ClassDescriptor> getChildrenInSamePackage() {
        for (SelectUnique target : ForEach2.selectUnique(this.children)) {
            target.yield = this.getPackagename().equals(((ClassDescriptor)target.value).getPackagename());
        }
        return (Set)ForEach.result();
    }

    private Set<ClassDescriptor> getTransitiveChildren() {
        if (this.transitiveChildrenCache.isEmpty()) {
            this.collectTransitiveChildren(this.transitiveChildrenCache);
        }
        return this.transitiveChildrenCache;
    }

    private void collectTransitiveChildren(Set<ClassDescriptor> result) {
        result.add(this);
        for (ClassDescriptor child : this.getChildren()) {
            if (result.contains(child)) continue;
            child.collectTransitiveChildren(result);
        }
    }

    private Set<ClassDescriptor> getTransitiveParents() {
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        this.collectTransitiveParents(result);
        return result;
    }

    private void collectTransitiveParents(Set<ClassDescriptor> result) {
        result.add(this);
        for (ClassDescriptor parent : this.parents) {
            if (result.contains(parent)) continue;
            parent.collectTransitiveParents(result);
        }
    }

    public int getCCD() {
        return this.getTransitiveChildren().size();
    }

    public int getTransitiveParentCount() {
        return this.getTransitiveParents().size();
    }

    public void prepareRemoval() {
        this.markAndRemoveAllOutgoingRelations();
        ClassDescriptorCleanup.registerForCleanup(this);
    }

    private void markAndRemoveAllOutgoingRelations() {
        for (ClassDescriptor target : this.children) {
            target.parents.remove(this);
        }
        this.children.clear();
        this.clearOwnAndParentsTransitiveChildrenCache();
    }

    public void removeFromPool() {
        this.clearOwnAndParentsTransitiveChildrenCache();
        for (ClassDescriptor source : this.parents) {
            source.children.remove(this);
        }
        this.parents.clear();
        ClassDescriptor.removeDescriptor(this.key);
    }

    public void addChild(ClassDescriptor target) {
        if (!this.equals(target)) {
            this.children.add(target);
            target.parents.add(this);
            this.clearOwnAndParentsTransitiveChildrenCache();
        }
    }

    public Set<ClassDescriptor> getParentsInOtherPackages() {
        HashSet<ClassDescriptor> result = new HashSet<ClassDescriptor>();
        for (ClassDescriptor parent : this.parents) {
            if (this.getPackagename().equals(parent.getPackagename())) continue;
            result.add(parent);
        }
        return result;
    }
}

