/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Cycle;

public class ClassCycles {
    private final List<Cycle<ClassDescriptor>> classCycles = new ArrayList<Cycle<ClassDescriptor>>();

    public ClassCycles(List<Set<ClassDescriptor>> cycles) {
        for (Set<ClassDescriptor> cycle : cycles) {
            if (cycle.size() <= 1) continue;
            this.classCycles.add(new Cycle<ClassDescriptor>(cycle));
        }
    }

    public int numberOfClassesInAnyCycles() {
        int count = 0;
        for (Cycle<ClassDescriptor> cycle : this.classCycles) {
            count += cycle.numberOfElements();
        }
        return count;
    }

    public boolean containsClass(ClassDescriptor descriptor) {
        for (Cycle<ClassDescriptor> cycle : this.classCycles) {
            if (!cycle.contains(descriptor)) continue;
            return true;
        }
        return false;
    }
}

