/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.TypeBindingChecker;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;

public class BoundTypeConverter {
    private final TypeBindingChecker bindingChecker = new TypeBindingChecker();
    private ASTNodeHelper nodeHelper;

    public BoundTypeConverter(ASTNodeHelper nodeHelper) {
        this.nodeHelper = nodeHelper;
    }

    public WrappedTypeBinding wrap(AbstractTypeDeclaration node) {
        if (node != null) {
            return this.wrap(this.nodeHelper.resolveBindingOf(node));
        }
        return null;
    }

    public WrappedTypeBinding wrap(SimpleType node) {
        if (node != null) {
            return this.wrap(this.nodeHelper.resolveBindingOf(node));
        }
        return null;
    }

    public WrappedTypeBinding wrap(SimpleName node) {
        if (node != null) {
            IBinding binding = this.nodeHelper.resolveBindingOf(node);
            if (binding instanceof ITypeBinding) {
                return this.wrap((ITypeBinding)binding);
            }
            if (binding instanceof IVariableBinding) {
                return this.wrap(((IVariableBinding)binding).getDeclaringClass());
            }
        }
        return null;
    }

    public WrappedTypeBinding wrap(MethodInvocation node) {
        IMethodBinding methodBinding;
        if (node != null && (methodBinding = node.resolveMethodBinding()) != null) {
            return this.wrap(methodBinding.getDeclaringClass());
        }
        return null;
    }

    public WrappedTypeBinding wrap(FieldAccess node) {
        if (node != null) {
            return this.wrap(this.nodeHelper.resolveTypeBindingOf(node));
        }
        return null;
    }

    public WrappedTypeBinding wrap(QualifiedName qualifier) {
        if (qualifier != null) {
            return this.wrap(this.nodeHelper.resolveTypeBindingOf(qualifier));
        }
        return null;
    }

    private WrappedTypeBinding wrap(ITypeBinding binding) {
        return this.bindingChecker.checkForRelevanceAndWrap(binding);
    }
}

