/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis.test;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.projectusus.core.basis.YellowCountCache;
import org.projectusus.core.testutil.ReflectionUtil;

public class YellowCountCacheTest {
    private IProject project1;
    private IProject project2;
    private IMarker[] markers;
    private YellowCountCache cache;

    @Before
    public void setup() throws Exception {
        this.cache = YellowCountCache.yellowCountCache();
        ReflectionUtil.setValue(this.cache, new HashMap(), "projectCounts");
        this.project1 = (IProject)Mockito.mock(IProject.class);
        this.project2 = (IProject)Mockito.mock(IProject.class);
    }

    @Test
    public void noMarkersInOneProject() throws Exception {
        this.markers = new IMarker[0];
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        this.cache.add(this.project1);
        Assert.assertEquals((long)1L, (long)this.cache.projects());
        Assert.assertEquals((long)0L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)0L, (long)this.cache.yellows());
    }

    @Test
    public void noMarkersInTwoProjects() throws Exception {
        this.markers = new IMarker[0];
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        Mockito.when((Object)this.project2.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        this.cache.add(this.project1);
        this.cache.add(this.project2);
        Assert.assertEquals((long)2L, (long)this.cache.projects());
        Assert.assertEquals((long)0L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)0L, (long)this.cache.yellows());
    }

    @Test
    public void noMarkersInTwoProjectsOneIsRemoved() throws Exception {
        this.markers = new IMarker[0];
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        Mockito.when((Object)this.project2.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        this.cache.add(this.project1);
        this.cache.add(this.project2);
        this.cache.clear(this.project1);
        Assert.assertEquals((long)1L, (long)this.cache.projects());
        Assert.assertEquals((long)0L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)0L, (long)this.cache.yellows());
    }

    @Test
    public void oneWarningInOneProject() throws Exception {
        this.markers = new IMarker[1];
        this.markers[0] = (IMarker)Mockito.mock(IMarker.class);
        Mockito.when((Object)this.markers[0].getAttribute("severity")).thenReturn((Object)new Integer(1));
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        this.cache.add(this.project1);
        Assert.assertEquals((long)1L, (long)this.cache.projects());
        Assert.assertEquals((long)1L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)1L, (long)this.cache.yellows());
    }

    @Test
    public void twoWarningsInOneProject() throws Exception {
        this.markers = new IMarker[3];
        this.markers[0] = (IMarker)Mockito.mock(IMarker.class);
        this.markers[1] = (IMarker)Mockito.mock(IMarker.class);
        this.markers[2] = (IMarker)Mockito.mock(IMarker.class);
        Mockito.when((Object)this.markers[0].getAttribute("severity")).thenReturn((Object)new Integer(1));
        Mockito.when((Object)this.markers[1].getAttribute("severity")).thenReturn((Object)new Integer(1));
        Mockito.when((Object)this.markers[2].getAttribute("severity")).thenReturn((Object)new Integer(2));
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        this.cache.add(this.project1);
        Assert.assertEquals((long)1L, (long)this.cache.projects());
        Assert.assertEquals((long)1L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)2L, (long)this.cache.yellows());
    }

    @Test
    public void oneWarningInOneOfTwoProjects() throws Exception {
        this.markers = new IMarker[1];
        this.markers[0] = (IMarker)Mockito.mock(IMarker.class);
        Mockito.when((Object)this.markers[0].getAttribute("severity")).thenReturn((Object)new Integer(1));
        Mockito.when((Object)this.project1.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)this.markers);
        Mockito.when((Object)this.project2.findMarkers(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)new IMarker[0]);
        this.cache.add(this.project1);
        this.cache.add(this.project2);
        Assert.assertEquals((long)2L, (long)this.cache.projects());
        Assert.assertEquals((long)1L, (long)this.cache.yellowProjects());
        Assert.assertEquals((long)1L, (long)this.cache.yellows());
    }
}

