/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis;

import java.text.MessageFormat;

public class YellowCountResult {
    private static final int COUNT_POSITION = 16;
    private static String wiseCrack_cool = " That's cool.";
    private static String wiseCrack_shame = " That's a shame.";
    private static String yellowCountResult_msg = "Yellow count is {0} ({1} of {2} projects are yellow).";
    private final int projectCount;
    private final int yellowCount;
    private final int yellowProjectCount;

    public YellowCountResult(int projectCount, int yellowCount, int yellowProjectCount) {
        this.projectCount = projectCount;
        this.yellowCount = yellowCount;
        this.yellowProjectCount = yellowProjectCount;
    }

    public int getYellowCount() {
        return this.yellowCount;
    }

    public int getYellowProjectCount() {
        return this.yellowProjectCount;
    }

    public int getProjectCount() {
        return this.projectCount;
    }

    public int getFormattedCountLength() {
        return MessageFormat.format("{0}", new Integer(this.yellowCount)).length();
    }

    public int getFormattedCountPosition() {
        return 16;
    }

    public String toString() {
        Integer iYellowCount = new Integer(this.yellowCount);
        Integer iYellowProjectCount = new Integer(this.yellowProjectCount);
        Integer iProjectCount = new Integer(this.projectCount);
        String wiseCrack = this.getWiseCrackString(this.yellowCount);
        return String.valueOf(MessageFormat.format(yellowCountResult_msg, iYellowCount, iYellowProjectCount, iProjectCount)) + wiseCrack;
    }

    private String getWiseCrackString(int count) {
        String result = "";
        if (count == 42) {
            result = wiseCrack_cool;
        } else if (count > 0) {
            result = wiseCrack_shame;
        }
        return result;
    }
}

