/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.projectusus.core.basis.YellowCountResult;

public class YellowCountCache {
    private static YellowCountCache instance = new YellowCountCache();
    private Map<IProject, Integer> projectCounts = new HashMap<IProject, Integer>();

    public static YellowCountCache yellowCountCache() {
        return instance;
    }

    private YellowCountCache() {
    }

    public void clear() {
        this.projectCounts = new HashMap<IProject, Integer>();
    }

    public void add(IProject project) {
        try {
            this.projectCounts.put(project, this.getNumberOfWarnings(project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)));
        }
        catch (CoreException coreException) {}
    }

    public void clear(IProject project) {
        this.projectCounts.remove(project);
    }

    public YellowCountResult getResult() {
        return new YellowCountResult(this.projects(), this.yellows(), this.yellowProjects());
    }

    public int yellowProjects() {
        int yellowProjects = 0;
        for (Integer count : this.projectCounts.values()) {
            if (count <= 0) continue;
            ++yellowProjects;
        }
        return yellowProjects;
    }

    public int yellows() {
        int yellows = 0;
        for (Integer count : this.projectCounts.values()) {
            yellows += count.intValue();
        }
        return yellows;
    }

    public int projects() {
        return this.projectCounts.size();
    }

    private Integer getNumberOfWarnings(IMarker[] markers) throws CoreException {
        int markerCount = 0;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.isWarning(marker)) {
                ++markerCount;
            }
            ++n2;
        }
        return new Integer(markerCount);
    }

    private boolean isWarning(IMarker marker) throws CoreException {
        Integer severity = (Integer)marker.getAttribute("severity");
        return severity != null && severity == 1;
    }
}

