/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaModelPath {
    private IProject project;
    private IFile file;
    private IType type;
    private IMethod method;

    public static JavaModelPath of(IJavaElement element) throws JavaModelException {
        IJavaElement ancestor = element.getAncestor(9);
        if (ancestor != null) {
            return new JavaModelPath((IMethod)ancestor);
        }
        ancestor = element.getAncestor(7);
        if (ancestor != null) {
            return new JavaModelPath((IType)ancestor);
        }
        return new JavaModelPath((IFile)element.getUnderlyingResource());
    }

    public JavaModelPath() {
    }

    public JavaModelPath(IProject project) {
        this.project = project;
    }

    public JavaModelPath(IFile file) {
        this(file.getProject());
        this.file = file;
    }

    public JavaModelPath(IType type) throws JavaModelException {
        this((IFile)type.getUnderlyingResource());
        this.type = type;
    }

    public JavaModelPath(IMethod method) throws JavaModelException {
        this((IType)method.getAncestor(7));
        this.method = method;
    }

    public boolean isRestrictedToProject() {
        return this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isRestrictedToFile() {
        return this.file != null;
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean isRestrictedToType() {
        return this.type != null;
    }

    public IJavaElement getType() {
        return this.type;
    }

    public boolean isRestrictedToMethod() {
        return this.method != null;
    }

    public IMethod getMethod() {
        return this.method;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("Project", (Object)this.project).append("File", (Object)this.file).append("Type", (Object)this.type).append("Method", (Object)this.method);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaModelPath && this.equals((JavaModelPath)obj);
    }

    private boolean equals(JavaModelPath other) {
        return new EqualsBuilder().append((Object)this.project, (Object)other.project).append((Object)this.file, (Object)other.file).append((Object)this.type, (Object)other.type).append((Object)this.method, (Object)other.method).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.project).append((Object)this.file).append((Object)this.type).append((Object)this.method).toHashCode();
    }
}

