/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.core.resources.IFile;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.SourceCodeLocation;

public class FileHotspot
implements Hotspot {
    private IFile file;
    private final int metricsValue;
    private final SourceCodeLocation location;

    public FileHotspot(SourceCodeLocation location, int metricsValue, IFile file) {
        this.location = location;
        this.metricsValue = metricsValue;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.location.getName();
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public int getMetricsValue() {
        return this.metricsValue;
    }

    public int getSourcePosition() {
        return this.location.getSourcePosition();
    }

    public int getLineNumber() {
        return this.location.getLineNumber();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileHotspot)) {
            return false;
        }
        FileHotspot other = (FileHotspot)obj;
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getFile(), (Object)other.getFile()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getFile()).toHashCode();
    }

    @Override
    public int compareTo(Hotspot o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + "-" + this.getMetricsValue() + "[" + super.toString() + "]";
    }

    @Override
    public String getPath() {
        return this.file.getFullPath().removeLastSegments(1).toOSString();
    }
}

