/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.basis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.projectusus.core.basis.ByHotnessComparator;
import org.projectusus.core.basis.CodeStatistic;
import org.projectusus.core.basis.Histogram;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.LocationType;

public class CodeProportion
extends PlatformObject {
    private final String label;
    private final String description;
    private final int violations;
    private final CodeStatistic basis;
    private final double average;
    private final List<Hotspot> hotspots;
    private final boolean hasHotspots;
    private final String tooltip;
    private final Histogram histogram;
    private final LocationType locationType;

    public CodeProportion(String label, String description, int violations, CodeStatistic basis, double average) {
        this(label, description, "", violations, basis, average, new ArrayList<Hotspot>(0), false, new Histogram(), LocationType.PATH);
    }

    public CodeProportion(String label, String description, String tooltip, int violations, CodeStatistic basis, double average, List<Hotspot> hotspots, Histogram histogram, LocationType locationType) {
        this(label, description, tooltip, violations, basis, average, hotspots, true, histogram, locationType);
    }

    private CodeProportion(String label, String description, String tooltip, int violations, CodeStatistic basis, double average, List<Hotspot> hotspots, boolean hasHotspots, Histogram histogram, LocationType locationType) {
        this.label = label;
        this.description = String.valueOf(label) + ": " + description;
        this.tooltip = tooltip;
        this.violations = violations;
        this.basis = basis;
        this.hasHotspots = hasHotspots;
        this.histogram = histogram;
        this.hotspots = this.sort(hotspots);
        this.average = average;
        this.locationType = locationType;
    }

    public double getAverage() {
        return this.average;
    }

    public int getViolations() {
        return this.violations;
    }

    public CodeStatistic getBasis() {
        return this.basis;
    }

    public String toString() {
        return String.valueOf(this.label) + ": " + this.violations + " / " + (Object)((Object)this.basis);
    }

    public String getMetricLabel() {
        return this.label;
    }

    public String getMetricDescription() {
        return this.description;
    }

    public List<Hotspot> getHotspots() {
        return this.hotspots;
    }

    private List<Hotspot> sort(List<Hotspot> passedHotspots) {
        ArrayList<Hotspot> result = new ArrayList<Hotspot>();
        result.addAll(passedHotspots);
        Collections.sort(result, new ByHotnessComparator());
        return result;
    }

    public boolean hasHotspots() {
        return this.hasHotspots;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public LocationType getLocationType() {
        return this.locationType;
    }
}

