/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.prefs.BackingStoreException;
import org.projectusus.c4j.C4JFileWriter;

public class UsusCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.projectusus.core";
    private static UsusCorePlugin plugin;

    public static UsusCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable throwable) {
        String msg = throwable.getMessage() == null ? "[No details.]" : throwable.getMessage();
        UsusCorePlugin.log(msg, throwable);
    }

    public static void log(String msg, Throwable throwable) {
        if (UsusCorePlugin.getDefault() != null) {
            Status status = new Status(4, PLUGIN_ID, 0, msg, throwable);
            UsusCorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public void savePreferences() {
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException bastox) {
            UsusCorePlugin.log(bastox);
        }
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        this.openC4JFileWriter();
        plugin = this;
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2) {
                    context.removeBundleListener((BundleListener)this);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin.savePreferences();
        plugin = null;
        this.closeC4JFileWriter();
        super.stop(context);
    }

    private void openC4JFileWriter() {
        try {
            File logFile = new File(this.getC4JLogFile());
            logFile.getParentFile().mkdirs();
            logFile.createNewFile();
            C4JFileWriter.setWriter(new PrintWriter(logFile));
        }
        catch (IOException e) {
            UsusCorePlugin.log(e);
        }
    }

    private void closeC4JFileWriter() {
        C4JFileWriter.closeWriter();
    }

    private String getC4JLogFile() throws IOException {
        return Platform.getInstanceLocation().getDataArea("org.projectusus.core/c4j.log").getFile();
    }
}

