/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.projectusus.core.CollectibleExtension;
import org.projectusus.core.UsusCorePlugin;

public class ExtensionCollector<T extends CollectibleExtension> {
    private static final String CLASS = "class";
    private final String extensionPointId;

    public ExtensionCollector(String extensionPointId) {
        this.extensionPointId = extensionPointId;
    }

    public Set<T> allExtensions() {
        HashSet<T> extensions = new HashSet<T>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement metricsElement = iConfigurationElementArray[n2];
            T extension = this.createExecutableExtension(metricsElement);
            if (extension != null) {
                extensions.add(extension);
            }
            ++n2;
        }
        return extensions;
    }

    private T createExecutableExtension(IConfigurationElement metricsElement) {
        try {
            return (T)((CollectibleExtension)metricsElement.createExecutableExtension(CLASS));
        }
        catch (CoreException exception) {
            UsusCorePlugin.log(exception);
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

