/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.osgi.framework.Bundle;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.ui.BugPrisonUIPlugin;
import org.projectusus.bugprison.ui.internal.BugPage;
import org.projectusus.core.util.Defect;

public class ReportBugWizard
extends Wizard {
    private Bug bug;
    private BugPage bugPage;

    public ReportBugWizard(Bug bug) {
        this.bug = bug;
        this.setHelpAvailable(false);
        this.setDefaultPageImageDescriptor(this.loadBanner());
    }

    private ImageDescriptor loadBanner() {
        return ImageDescriptor.createFromURL((URL)this.bannerUrl());
    }

    private URL bannerUrl() {
        try {
            Bundle bundle = BugPrisonUIPlugin.getDefault().getBundle();
            return new URL(bundle.getEntry("/"), "icons/full/wizban/report_bug.png");
        }
        catch (MalformedURLException exception) {
            throw new Defect("could not load bug banner", (Throwable)exception);
        }
    }

    public void addPages() {
        this.bugPage = new BugPage(this.bug);
        this.addPage((IWizardPage)this.bugPage);
    }

    public boolean performFinish() {
        this.bug = this.bugPage.getBug();
        return true;
    }

    public Bug getBug() {
        return this.bug;
    }
}

