/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.ui.internal;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.IBuggyProject;
import org.projectusus.bugprison.core.NullBuggyProject;
import org.projectusus.bugprison.core.SourceCodeLocation;
import org.projectusus.bugprison.ui.internal.ReportBugWizard;
import org.projectusus.core.project2.IUSUSProject;
import org.projectusus.core.project2.NullUsusProject;
import org.projectusus.core.statistics.visitors.MethodCountVisitor;
import org.projectusus.core.statistics.visitors.MethodVisitor;
import org.projectusus.ui.internal.UsusUIPlugin;
import org.projectusus.ui.internal.selection.JDTWorkspaceEditorInputAnalysis;

public class ReportBugAction
extends Action
implements IEditorActionDelegate {
    private ICompilationUnit selectedJavaClass;
    private IJavaElement selectedElement;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        this.init();
        if (this.getUsusProject().isUsusProject() && this.isMethodSelected()) {
            ReportBugWizard wizard = new ReportBugWizard(this.initBugData());
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Bug bug = wizard.getBug();
                this.getBuggyProject().saveBug(bug);
            }
        }
    }

    private void init() {
        try {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEditorInput editorInput = workbenchWindow.getActivePage().getActiveEditor().getEditorInput();
            JDTWorkspaceEditorInputAnalysis analysis = new JDTWorkspaceEditorInputAnalysis(editorInput);
            this.selectedJavaClass = analysis.getCompilationUnit();
            ISelection selection = workbenchWindow.getSelectionService().getSelection();
            this.selectedElement = analysis.getSelectedElement(selection);
        }
        catch (Exception e) {
            UsusUIPlugin.getDefault().log(e);
        }
    }

    private Bug initBugData() {
        Bug bug = new Bug();
        this.initBugClassData(bug);
        return bug;
    }

    private void initBugClassData(Bug bug) {
        this.fillClassMetrics(bug);
        this.fillMethodMetrics(bug, this.getSelectedMethod());
        bug.setLocation(SourceCodeLocation.getMethodLocation((IMethod)this.getSelectedMethod()));
    }

    private void fillClassMetrics(Bug bug) {
        bug.getBugMetrics().setNumberOfMethods(new MethodCountVisitor().visitAndReturn().getMethodCount());
    }

    private void fillMethodMetrics(Bug bug, IMethod method) {
        try {
            MethodVisitor visitor = new MethodVisitor(method).visitAndReturn();
            bug.getBugMetrics().setCyclomaticComplexity(visitor.getCCValue());
            bug.getBugMetrics().setMethodLength(visitor.getMLValue());
        }
        catch (JavaModelException javaModelException) {}
    }

    private IMethod getSelectedMethod() {
        return SourceCodeLocation.getMethod((IJavaElement)this.selectedElement);
    }

    private boolean isMethodSelected() {
        return this.getSelectedMethod() != null;
    }

    private IBuggyProject getBuggyProject() {
        if (this.selectedJavaClass == null) {
            return new NullBuggyProject();
        }
        IJavaProject project = this.selectedJavaClass.getJavaProject();
        return (IBuggyProject)project.getProject().getAdapter(IBuggyProject.class);
    }

    private IUSUSProject getUsusProject() {
        if (this.selectedJavaClass == null) {
            return new NullUsusProject();
        }
        IJavaProject project = this.selectedJavaClass.getJavaProject();
        return (IUSUSProject)project.getProject().getAdapter(IUSUSProject.class);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

