/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.ui.internal;

import java.util.Arrays;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.widgets.Composite;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.ui.internal.BugsColumnDesc;
import org.projectusus.bugprison.ui.internal.BugsContentProvider;
import org.projectusus.bugprison.ui.internal.BugsLP;
import org.projectusus.ui.viewer.IColumnDesc;
import org.projectusus.ui.viewer.TableViewPart;

public class BugsView
extends TableViewPart<Bug> {
    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.refresh();
        this.initOpenListener();
    }

    private void initOpenListener() {
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Bug bug = BugsView.this.extractBug(event.getSelection());
                if (bug != null) {
                    BugsView.this.openBugInEditor(bug);
                }
            }
        });
    }

    private void openBugInEditor(Bug bug) {
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject javaProject = model.getJavaProject(bug.getLocation().getProject());
            IType type = javaProject.findType(bug.getLocation().getPackageName(), bug.getLocation().getClassName(), (IProgressMonitor)new NullProgressMonitor());
            JavaUI.openInEditor((IJavaElement)type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bug extractBug(ISelection selection) {
        Object element;
        Bug result = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof Bug) {
            result = (Bug)element;
        }
        return result;
    }

    protected BugsContentProvider getContentProvider() {
        return new BugsContentProvider();
    }

    protected BugsLP getLabelProvider() {
        return new BugsLP(Arrays.asList(BugsColumnDesc.values()));
    }

    private void refresh() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.viewer.setInput((Object)input);
    }

    protected IColumnDesc<Bug>[] getColumns() {
        return BugsColumnDesc.values();
    }
}

