/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.ui.internal;

import org.projectusus.bugprison.core.Bug;
import org.projectusus.ui.viewer.IColumnDesc;

enum BugsColumnDesc implements IColumnDesc<Bug>
{
    COVERED{

        public String getLabel(Bug bug) {
            return bug.getTitle();
        }
    }
    ,
    PACKAGE{

        public String getLabel(Bug bug) {
            return bug.getLocation().getPackageName();
        }
    }
    ,
    CLASS_NAME{

        public String getLabel(Bug bug) {
            return bug.getLocation().getClassName();
        }
    }
    ,
    METHOD_NAME{

        public String getLabel(Bug bug) {
            return bug.getLocation().getMethodName();
        }
    }
    ,
    METHOD_LENGTH{

        public String getLabel(Bug bug) {
            return String.valueOf(bug.getBugMetrics().getMethodLength());
        }
    }
    ,
    CYCLOMATIC_COMPLEXITY{

        public String getLabel(Bug bug) {
            return String.valueOf(bug.getBugMetrics().getCyclomaticComplexity());
        }
    }
    ,
    NUMBER_OF_METHODS_IN_CLASS{

        public String getLabel(Bug bug) {
            return String.valueOf(bug.getBugMetrics().getNumberOfMethods());
        }
    };


    private BugsColumnDesc() {
    }

    public boolean hasImage() {
        return false;
    }

    public boolean isHasText() {
        return true;
    }

    /* synthetic */ BugsColumnDesc(String string, int n, BugsColumnDesc bugsColumnDesc) {
        this();
    }
}

