/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.ui.internal;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.projectusus.bugprison.core.Bug;

public class BugPage
extends WizardPage {
    private Text packageName;
    private Text className;
    private Text methodName;
    private final Bug bug;
    private Text title;
    private Text cyclomaticComplexity;
    private Text methodLength;
    private Text numberOfMethodsInClass;

    public BugPage(Bug bug) {
        super("");
        this.setTitle("Report Bug");
        this.setDescription("Report Bug");
        this.bug = bug;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.title = this.createEditableText(composite, "Title");
        this.packageName = this.createNotEditableText(composite, "Packagename");
        this.className = this.createNotEditableText(composite, "Classname");
        this.methodName = this.createNotEditableText(composite, "MethodName");
        this.cyclomaticComplexity = this.createNotEditableText(composite, "Cyclomatic complexity");
        this.methodLength = this.createNotEditableText(composite, "Method length");
        this.numberOfMethodsInClass = this.createNotEditableText(composite, "Number of methods in class");
        this.initView();
        this.setControl((Control)composite);
    }

    private void initView() {
        this.title.setText(this.bug.getTitle());
        this.packageName.setText(this.bug.getLocation().getPackageName());
        this.className.setText(this.bug.getLocation().getClassName());
        this.methodName.setText(this.bug.getLocation().getMethodName());
        this.cyclomaticComplexity.setText(String.valueOf(this.bug.getBugMetrics().getCyclomaticComplexity()));
        this.methodLength.setText(String.valueOf(this.bug.getBugMetrics().getMethodLength()));
        this.numberOfMethodsInClass.setText(String.valueOf(this.bug.getBugMetrics().getNumberOfMethods()));
    }

    private Text createNotEditableText(Composite composite, String labelText) {
        return this.createText(composite, labelText, false);
    }

    private Text createEditableText(Composite composite, String labelText) {
        Text text = this.createText(composite, labelText, true);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BugPage.this.updateModel();
            }
        });
        return text;
    }

    private void updateModel() {
        this.bug.setTitle(this.title.getText());
        if (this.bug.getTitle().length() == 0) {
            this.setMessage("Please insert title", 2);
        } else {
            this.setMessage(null);
        }
    }

    private Text createText(Composite composite, String labelText, boolean editable) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        int style = 0;
        if (editable) {
            style |= 0x800;
        }
        Text text = new Text(composite, style);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.setEditable(editable);
        return text;
    }

    public Bug getBug() {
        return this.bug;
    }
}

