/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public final class PrettyPrinter {
    public static String objectAsString(IObject stringObject, int limit) throws SnapshotException {
        Object valueObj = stringObject.resolveValue("value");
        if (!(valueObj instanceof IPrimitiveArray)) {
            return null;
        }
        IPrimitiveArray charArray = (IPrimitiveArray)valueObj;
        Object countObj = stringObject.resolveValue("count");
        if (countObj == null) {
            if (charArray.getType() == 8) {
                Object o;
                Object coder = stringObject.resolveValue("coder");
                if (coder instanceof Byte && (Byte)coder == 0) {
                    return PrettyPrinter.compactByteArrayAsString(charArray, 0, charArray.getLength(), limit);
                }
                Collection<IClass> clss = stringObject.getSnapshot().getClassesByName("java.lang.StringUTF16", false);
                int bigEndian = !clss.isEmpty() ? ((o = clss.iterator().next().resolveValue("HI_BYTE_SHIFT")) instanceof Integer && (Integer)o == 8 ? 1 : 0) : 0;
                return PrettyPrinter.byteArrayAsString(charArray, 0, charArray.getLength() / 2, limit, bigEndian);
            }
            return PrettyPrinter.arrayAsString(charArray, 0, charArray.getLength(), limit);
        }
        if (!(countObj instanceof Integer)) {
            return null;
        }
        Integer count = (Integer)countObj;
        if (count == 0) {
            return "";
        }
        Integer offset = 0;
        Object offsetObj = stringObject.resolveValue("offset");
        if (offsetObj instanceof Integer) {
            offset = (Integer)offsetObj;
        }
        if (charArray.getType() == 8) {
            Object coder = stringObject.resolveValue("coder");
            if (coder instanceof Byte && (Byte)coder == 0) {
                return PrettyPrinter.compactByteArrayAsString(charArray, offset, count, limit);
            }
            Object o = stringObject.getSnapshot().getClassesByName("java.lang.String", false).iterator().next().resolveValue("HI_BYTE_SHIFT");
            int bigEndian = o instanceof Integer && (Integer)o == 8 ? 1 : 0;
            return PrettyPrinter.byteArrayAsString(charArray, offset, count, limit, bigEndian);
        }
        return PrettyPrinter.arrayAsString(charArray, offset, count, limit);
    }

    public static String arrayAsString(IPrimitiveArray charArray, int offset, int count, int limit) {
        char[] value;
        int contentToRead;
        if (charArray.getType() != 5) {
            return null;
        }
        int length = charArray.getLength();
        int n = contentToRead = count <= limit ? count : limit;
        if (contentToRead > length - offset) {
            contentToRead = length - offset;
        }
        if ((value = offset == 0 && length == contentToRead ? (char[])charArray.getValueArray() : (char[])charArray.getValueArray(offset, contentToRead)) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(value.length);
        int ii = 0;
        while (ii < value.length) {
            char val = value[ii];
            if (val >= ' ' && val < '\u007f') {
                result.append(val);
            } else {
                result.append("\\u").append(String.format("%04x", 0xFFFF & val));
            }
            ++ii;
        }
        if (limit < count) {
            result.append("...");
        }
        return result.toString();
    }

    static String compactByteArrayAsString(IPrimitiveArray byteArray, int offset, int count, int limit) {
        byte[] value;
        int contentToRead;
        if (byteArray.getType() != 8) {
            return null;
        }
        int length = byteArray.getLength();
        int n = contentToRead = count <= limit ? count : limit;
        if (contentToRead > length - offset) {
            contentToRead = length - offset;
        }
        if ((value = offset == 0 && length == contentToRead ? (byte[])byteArray.getValueArray() : (byte[])byteArray.getValueArray(offset, contentToRead)) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(value.length);
        int ii = 0;
        while (ii < value.length) {
            byte val = value[ii];
            if (val >= 32 && val < 127) {
                result.append((char)val);
            } else {
                result.append("\\u").append(String.format("%04x", 0xFFFF & val));
            }
            ++ii;
        }
        if (limit < count) {
            result.append("...");
        }
        return result.toString();
    }

    static String byteArrayAsString(IPrimitiveArray byteArray, int offset, int count, int limit, int bigEndian) {
        byte[] value;
        int contentToRead;
        if (byteArray.getType() != 8) {
            return null;
        }
        int length = byteArray.getLength();
        int n = contentToRead = count <= limit ? count * 2 : limit * 2;
        if (contentToRead > length - offset * 2) {
            contentToRead = length - offset * 2;
        }
        if ((value = offset == 0 && length == contentToRead ? (byte[])byteArray.getValueArray() : (byte[])byteArray.getValueArray(offset, contentToRead)) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(value.length / 2);
        int ii = 0;
        while (ii < value.length) {
            byte val = value[ii + bigEndian];
            byte val2 = value[ii + 1 - bigEndian];
            if (val >= 32 && val < 127 && val2 == 0) {
                result.append((char)val);
            } else {
                result.append("\\u").append(String.format("%04x", 0xFF & val | (0xFF & val2) << 8));
            }
            ii += 2;
        }
        if (limit < count) {
            result.append("...");
        }
        return result.toString();
    }

    private PrettyPrinter() {
    }
}

