/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonMapExtractor
implements IMapExtractor {
    private final String keyField;
    private final String valueField;

    public SingletonMapExtractor(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        return 1;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return 1;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return new int[]{coll.getObjectId()};
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return coll.resolveValue(this.valueField) != null ? 1 : 0;
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return 0.0;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) throws SnapshotException {
        return Collections.singletonMap((IObject)coll.resolveValue(this.keyField), (IObject)coll.resolveValue(this.valueField)).entrySet().iterator();
    }

    @Override
    public boolean hasFillRatio() {
        return true;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return this.getNumberOfNotNullElements(coll).doubleValue();
    }
}

