/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.viewer;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.Viewer;
import org.projectusus.ui.viewer.RefreshViewerOnResourceChange;

public class WorkspaceRootConnection {
    private IResourceChangeListener listener;

    public void update(Viewer viewer, Object oldInput, Object newInput) {
        this.disconnectFrom(oldInput);
        this.connectTo(newInput, viewer);
    }

    private void connectTo(Object input, Viewer viewer) {
        if (input instanceof IWorkspaceRoot) {
            this.listener = this.createListener(viewer);
            this.toWorkspace(input).addResourceChangeListener(this.listener);
        }
    }

    private IWorkspace toWorkspace(Object input) {
        return ((IWorkspaceRoot)input).getWorkspace();
    }

    private void disconnectFrom(Object input) {
        if (input instanceof IWorkspaceRoot && this.listener != null) {
            this.toWorkspace(input).removeResourceChangeListener(this.listener);
            this.listener = null;
        }
    }

    protected IResourceChangeListener createListener(Viewer viewer) {
        return new RefreshViewerOnResourceChange(viewer);
    }
}

