/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.viewer;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.projectusus.ui.viewer.AnnotationReader;
import org.projectusus.ui.viewer.ColumnByLabelSorter;
import org.projectusus.ui.viewer.IColumnDesc;
import org.projectusus.ui.viewer.UsusTreeColumn;

public class UsusTreeViewer<T>
extends TreeViewer {
    private static final int STYLE = 66306;

    public UsusTreeViewer(Composite parent, IColumnDesc<T>[] columns) {
        super(new Tree(parent, 66306));
        TableLayout layout = this.createTree();
        this.createColumns(layout, columns);
    }

    private TableLayout createTree() {
        TableLayout layout = new TableLayout();
        Tree tree = this.getTree();
        tree.setLayout((Layout)layout);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.layout(true);
        return layout;
    }

    private void createColumns(TableLayout layout, IColumnDesc<T>[] columns) {
        int i = 0;
        while (i < columns.length) {
            IColumnDesc<T> desc = columns[i];
            UsusTreeColumn ususTreeColumn = new AnnotationReader(desc).compute();
            TreeViewerColumn column = this.createColumn(ususTreeColumn.align().toSwtStyle());
            column.getColumn().setText(ususTreeColumn.header());
            if (ususTreeColumn.sortable()) {
                new ColumnByLabelSorter((StructuredViewer)this, column.getColumn(), i, ususTreeColumn.numeric());
            }
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(ususTreeColumn.weight()));
            ++i;
        }
    }

    private TreeViewerColumn createColumn(int style) {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, style);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        return column;
    }

    public void resetColumnSorting() {
        this.getTree().setSortColumn(null);
        this.getTree().setSortDirection(0);
    }
}

