/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.viewer;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.projectusus.ui.viewer.AnnotationReader;
import org.projectusus.ui.viewer.ColumnDescLabelProvider;
import org.projectusus.ui.viewer.IColumnDesc;
import org.projectusus.ui.viewer.UsusTreeColumn;

public abstract class TableViewPart<T>
extends ViewPart {
    protected TableViewer viewer;

    protected abstract IColumnDesc<T>[] getColumns();

    protected abstract IStructuredContentProvider getContentProvider();

    protected abstract ColumnDescLabelProvider<T> getLabelProvider();

    protected void createViewer(Composite parent) {
        Table table = this.createTable(parent);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider(this.getLabelProvider());
    }

    protected Table createTable(Composite parent) {
        Composite comp = new Composite(parent, 0);
        int style = 66052;
        Table result = new Table(comp, style);
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        result.setLinesVisible(true);
        result.setHeaderVisible(true);
        this.createColumns(result, layout);
        return result;
    }

    protected void createColumns(Table table, TableColumnLayout layout) {
        IColumnDesc<T>[] iColumnDescArray = this.getColumns();
        int n = iColumnDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnDesc<T> columnDesc = iColumnDescArray[n2];
            UsusTreeColumn ususTreeColumn = new AnnotationReader(columnDesc).compute();
            TableColumn column = new TableColumn(table, ususTreeColumn.align().toSwtStyle());
            ColumnWeightData data = new ColumnWeightData(ususTreeColumn.weight());
            layout.setColumnData((Widget)column, (ColumnLayoutData)data);
            column.setText(ususTreeColumn.header());
            ++n2;
        }
    }

    public void setFocus() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }
}

