/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.viewer;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

class ColumnByLabelSorter
extends ViewerComparator {
    private static final DecimalFormat formatter = new DecimalFormat("#.##");
    private final TreeColumn column;
    private final StructuredViewer viewer;
    private final int columnIndex;
    private boolean ascending = false;
    private final boolean numeric;

    public ColumnByLabelSorter(StructuredViewer viewer, TreeColumn column, int columnIndex, boolean numeric) {
        this.column = column;
        this.viewer = viewer;
        this.columnIndex = columnIndex;
        this.numeric = numeric;
        this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnByLabelSorter.this.sortAndActualizeSortOrder();
            }
        });
    }

    void sortAndActualizeSortOrder() {
        if (this.viewer.getComparator() == this) {
            this.ascending = !this.ascending;
        }
        Tree table = this.column.getParent();
        table.setSortColumn(this.column);
        table.setSortDirection(this.ascending ? 128 : 1024);
        if (this.viewer.getComparator() == this) {
            this.viewer.refresh();
        }
        this.viewer.setComparator((ViewerComparator)this);
    }

    public int compare(Viewer viewr, Object o1, Object o2) {
        return (this.ascending ? 1 : -1) * this.doCompare(o1, o2);
    }

    protected int doCompare(Object o1, Object o2) {
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.viewer.getLabelProvider();
        String text1 = labelProvider.getColumnText(o1, this.columnIndex);
        String text2 = labelProvider.getColumnText(o2, this.columnIndex);
        if (this.numeric) {
            try {
                Number number1 = formatter.parse(text1);
                Number number2 = formatter.parse(text2);
                return (int)Math.signum(number1.doubleValue() - number2.doubleValue());
            }
            catch (ParseException parseException) {}
        }
        return text1.compareTo(text2);
    }
}

