/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.viewer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.projectusus.ui.internal.UsusUIPlugin;
import org.projectusus.ui.viewer.IColumnDesc;
import org.projectusus.ui.viewer.UsusTreeColumn;

class AnnotationReader {
    private final IColumnDesc<?> columnDescEnumValue;

    AnnotationReader(IColumnDesc<?> enumValue) {
        this.columnDescEnumValue = enumValue;
    }

    UsusTreeColumn compute() {
        UsusTreeColumn result = null;
        try {
            Field field = this.loadField();
            Annotation[] annotationArray = field.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof UsusTreeColumn) {
                    result = (UsusTreeColumn)annotation;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            UsusUIPlugin.getDefault().log(ex);
        }
        return result;
    }

    private Field loadField() throws NoSuchFieldException {
        Class<?> enumClass = this.columnDescEnumValue.getClass();
        if (enumClass.isAnonymousClass()) {
            enumClass = enumClass.getEnclosingClass();
        }
        return enumClass.getDeclaredField(this.columnDescEnumValue.toString());
    }
}

