/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.projectusus.ui.internal.UsusUIPlugin;

public final class EditorOpener {
    public void openEditor(IFile file) {
        if (file == null) {
            return;
        }
        try {
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IFile)file);
        }
        catch (PartInitException paix) {
            UsusUIPlugin.getDefault().getLog().log(paix.getStatus());
        }
    }

    public void openEditorAt(ICompilationUnit compilationUnit, int sourcePosition) {
        if (compilationUnit != null) {
            try {
                this.openJavaEditor(compilationUnit, sourcePosition);
            }
            catch (Exception ex) {
                UsusUIPlugin.getDefault().log(ex);
            }
        }
    }

    private void openJavaEditor(ICompilationUnit compilationUnit, int sourcePosition) throws Exception {
        IJavaElement javaElement = compilationUnit.getElementAt(sourcePosition);
        if (javaElement == null) {
            javaElement = compilationUnit.getPrimaryElement();
        }
        if (javaElement != null) {
            JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
        }
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

