/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.preferences;

import java.util.HashSet;
import java.util.SortedSet;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.projectusus.core.UsusCorePlugin;
import org.projectusus.core.statistics.CockpitExtensionPref;
import org.projectusus.core.statistics.RegisteredCockpitExtensionsCollector;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.ui.preferences.UsusPreferencesContentProvider;
import org.projectusus.ui.preferences.UsusPreferencesStyledLabelProvider;

public class UsusPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private SortedSet<CockpitExtensionPref> extensionsStates;
    private CheckboxTableViewer viewer;

    public UsusPreferencePage() {
        this.setDescription("Enable/disable the registered Usus Metric Statistics:");
    }

    public void init(IWorkbench workbench) {
        this.extensionsStates = RegisteredCockpitExtensionsCollector.getExtensionsStates();
    }

    protected Control createContents(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.viewer.setContentProvider((IContentProvider)new UsusPreferencesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new UsusPreferencesStyledLabelProvider()));
        this.viewer.setInput(this.extensionsStates);
        this.viewer.setCheckedElements((Object[])this.collectCheckedElements());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                UsusPreferencePage.this.updatePrefsElement(event.getElement(), event.getChecked());
            }
        });
        return this.viewer.getControl();
    }

    private CockpitExtensionPref[] collectCheckedElements() {
        HashSet<CockpitExtensionPref> checkedElements = new HashSet<CockpitExtensionPref>();
        for (CockpitExtensionPref pref : this.extensionsStates) {
            if (!pref.isOn()) continue;
            checkedElements.add(pref);
        }
        return checkedElements.toArray(new CockpitExtensionPref[0]);
    }

    protected void updatePrefsElement(Object element, boolean checked) {
        if (element instanceof CockpitExtensionPref) {
            ((CockpitExtensionPref)element).setOn(checked);
        }
    }

    public boolean performOk() {
        RegisteredCockpitExtensionsCollector.saveExtensionsStates(this.extensionsStates);
        UsusCorePlugin.getDefault().savePreferences();
        UsusModelProvider.ususModel().refreshCodeProportions();
        return super.performOk();
    }

    protected void performDefaults() {
        CockpitExtensionPref.restoreDefaults(this.extensionsStates);
        this.viewer.setCheckedElements((Object[])this.collectCheckedElements());
        super.performDefaults();
    }
}

