/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.yellowcount;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.basis.YellowCountCache;
import org.projectusus.core.basis.YellowCountResult;
import org.projectusus.core.statistics.UsusModelProvider;

public class YellowCountView
extends ViewPart {
    private StyledText styledText;
    private IUsusModelListener listener;
    private final ColorRegistry colorRegistry = new ColorRegistry();

    public void createPartControl(Composite parent) {
        this.styledText = new StyledText(parent, 64);
        this.styledText.setEditable(false);
        this.styledText.setBackground(this.getBackgroundColor());
        this.listener = new IUsusModelListener(){

            public void ususModelChanged() {
                YellowCountView.this.display(YellowCountCache.yellowCountCache().getResult());
            }
        };
        UsusModelProvider.ususModel().addUsusModelListener(this.listener);
        this.display(YellowCountCache.yellowCountCache().getResult());
    }

    public void setFocus() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            this.styledText.setFocus();
        }
    }

    public void dispose() {
        UsusModelProvider.ususModel().removeUsusModelListener(this.listener);
        super.dispose();
    }

    private void display(final YellowCountResult countResult) {
        final String displayString = countResult.toString();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (YellowCountView.this.styledText != null && !YellowCountView.this.styledText.isDisposed()) {
                    YellowCountView.this.styledText.setText(displayString);
                    YellowCountView.this.styledText.setBackground(YellowCountView.this.getBackgroundColor());
                    YellowCountView.this.styledText.setStyleRange(YellowCountView.this.createStyleRange(countResult));
                    YellowCountView.this.styledText.redraw();
                }
            }
        });
    }

    private Color getBackgroundColor() {
        int fade = YellowCountCache.yellowCountCache().getResult().getYellowCount();
        RGB rgb = new RGB(255, 255, Math.max(255 - fade, 0));
        if (!this.colorRegistry.hasValueFor(rgb.toString())) {
            this.colorRegistry.put(rgb.toString(), rgb);
        }
        return this.colorRegistry.get(rgb.toString());
    }

    private StyleRange createStyleRange(YellowCountResult countResult) {
        Color foreground = this.styledText.getForeground();
        Color background = this.styledText.getBackground();
        int position = countResult.getFormattedCountPosition();
        int length = countResult.getFormattedCountLength();
        return new StyleRange(position, length, foreground, background, 1);
    }
}

