/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.selection;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.ui.internal.selection.EditorInputAnalysis;
import org.projectusus.ui.internal.selection.ICompilationUnitInputLoader;

public class EditorInputAnalysisTest {
    private ICompilationUnitInputLoader loader;
    private IEditorInput editorInput;
    private ICompilationUnit compilationUnit;
    private IJavaElement javaElement;
    private EditorInputAnalysis inputAnalysis;

    @Before
    public void setUp() throws Exception {
        this.loader = (ICompilationUnitInputLoader)Mockito.mock(ICompilationUnitInputLoader.class);
        this.editorInput = (IEditorInput)Mockito.mock(IEditorInput.class);
        this.compilationUnit = (ICompilationUnit)Mockito.mock(ICompilationUnit.class);
        this.javaElement = (IJavaElement)Mockito.mock(IMethod.class);
        Mockito.when((Object)this.loader.loadCompilationUnit(this.editorInput)).thenReturn((Object)this.compilationUnit);
        Mockito.when((Object)this.compilationUnit.getElementAt(1)).thenReturn((Object)this.javaElement);
        this.inputAnalysis = new EditorInputAnalysis(this.loader, this.editorInput);
    }

    @Test(expected=IllegalArgumentException.class)
    public void dontAcceptMissingLoader() {
        new EditorInputAnalysis(null, null);
    }

    @Test
    public void canHandleNull() {
        EditorInputAnalysis analysis = new EditorInputAnalysis(this.loader, null);
        Assert.assertNull((Object)analysis.getCompilationUnit());
        Assert.assertNull((Object)analysis.getSelectedElement(null));
    }

    @Test
    public void extractCompilationUnitFromInput() {
        Assert.assertEquals((Object)this.compilationUnit, (Object)this.inputAnalysis.getCompilationUnit());
    }

    @Test
    public void nullSelectionReturnsCompilationUnit() {
        Assert.assertEquals((Object)this.compilationUnit, (Object)this.inputAnalysis.getSelectedElement(null));
    }

    @Test
    public void extractMethodFromTextSelection() {
        TextSelection selection = new TextSelection(1, 1);
        Assert.assertEquals((Object)this.javaElement, (Object)this.inputAnalysis.getSelectedElement((ISelection)selection));
    }
}

