/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.selection;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.projectusus.ui.internal.UsusUIPlugin;
import org.projectusus.ui.internal.selection.ICompilationUnitInputLoader;

public class EditorInputAnalysis {
    private final ICompilationUnit compilationUnit;

    EditorInputAnalysis(ICompilationUnitInputLoader loader, IEditorInput editorInput) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        this.compilationUnit = loader.loadCompilationUnit(editorInput);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public IJavaElement getSelectedElement(ISelection selection) {
        if (selection instanceof TextSelection) {
            try {
                IJavaElement element = this.compilationUnit.getElementAt(((TextSelection)selection).getOffset());
                return element == null ? this.compilationUnit : element;
            }
            catch (JavaModelException jamox) {
                UsusUIPlugin.getDefault().log((Exception)((Object)jamox));
            }
        }
        return this.compilationUnit;
    }
}

