/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.infopresenter.infomodel;

import org.eclipse.jdt.core.IMethod;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.ui.internal.proportions.infopresenter.infomodel.MethodFormatter;

public class MethodFormatterTest {
    private final IMethod javaElement = (IMethod)Mockito.mock(IMethod.class);

    @Test
    public void formatHeadForArrayParameter() throws Exception {
        this.prepareExpectations("([Ljava.lang.String;)QString;", "QString;");
        MethodFormatter formatter = new MethodFormatter(this.javaElement);
        Assert.assertEquals((Object)"String n(java.lang.String[])", (Object)formatter.formatHeadInfo());
    }

    @Test
    public void formatHeadForMultipleParameters() throws Exception {
        this.prepareExpectations("(QString;I)V", "V");
        MethodFormatter formatter = new MethodFormatter(this.javaElement);
        Assert.assertEquals((Object)"void n(String, int)", (Object)formatter.formatHeadInfo());
    }

    @Test
    public void formatHeadWithoutParameters() throws Exception {
        this.prepareExpectations("()I", "I");
        MethodFormatter formatter = new MethodFormatter(this.javaElement);
        Assert.assertEquals((Object)"int n()", (Object)formatter.formatHeadInfo());
    }

    private void prepareExpectations(String signature, String returnType) throws Exception {
        Mockito.when((Object)this.javaElement.getElementName()).thenReturn((Object)"n");
        Mockito.when((Object)this.javaElement.getSignature()).thenReturn((Object)signature);
        Mockito.when((Object)this.javaElement.getReturnType()).thenReturn((Object)returnType);
    }
}

