/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import org.eclipse.swt.widgets.Display;
import org.projectusus.ui.internal.AnalysisDisplayModel;
import org.projectusus.ui.internal.Snapshot;
import org.projectusus.ui.internal.proportions.cockpit.ISnapshotView;
import org.projectusus.ui.internal.proportions.cockpit.SnapshotInfoBuilder;

public class SnapshotInfoUpdater
implements Runnable {
    private final SnapshotInfoBuilder builder = new SnapshotInfoBuilder();
    private final ISnapshotView view;
    private boolean running = true;

    public SnapshotInfoUpdater(ISnapshotView view) {
        this.view = view;
    }

    public synchronized void stop() {
        this.running = false;
    }

    @Override
    public synchronized void run() {
        if (this.running) {
            this.update();
            this.schedule();
        }
    }

    public void start() {
        this.schedule();
    }

    private synchronized void schedule() {
        if (this.running) {
            Display.getDefault().timerExec(10000, (Runnable)this);
        }
    }

    private void update() {
        this.update(AnalysisDisplayModel.displayModel().getSnapshot());
    }

    public void update(Snapshot snapshot) {
        this.view.updateSnapshotInfo(this.builder.buildInfo(snapshot));
    }
}

