/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.ui.internal.Snapshot;
import org.projectusus.ui.internal.proportions.cockpit.SnapshotInfoBuilder;

public class SnapshotInfoBuilderTest {
    private static final int MINUTES = 60;
    private static final int HOURS = 3600;
    private static final int DAYS = 86400;
    private final SnapshotInfoBuilder builder = new SnapshotInfoBuilder();
    private final Date now = new Date();

    @Test
    public void buildInfo() {
        String info = this.builder.buildInfo(new Snapshot());
        Assert.assertThat((Object)info, (Matcher)Matchers.startsWith((String)"Snapshot taken at "));
        Assert.assertThat((Object)info, (Matcher)Matchers.endsWith((String)" (just now)"));
    }

    @Test
    public void buildAgoMessage_InTheFuture() {
        Assert.assertThat((Object)this.builder.buildAgoMessage(this.secondsAgo(-1), this.now), (Matcher)Matchers.equalTo((Object)"in the future"));
    }

    @Test
    public void buildAgoMessage_JustNow() {
        Assert.assertThat((Object)this.builder.buildAgoMessage(this.now), (Matcher)Matchers.equalTo((Object)"just now"));
        Assert.assertThat((Object)this.builder.buildAgoMessage(this.now, this.now), (Matcher)Matchers.equalTo((Object)"just now"));
        Assert.assertThat((Object)this.builder.buildAgoMessage(this.secondsAgo(9), this.now), (Matcher)Matchers.equalTo((Object)"just now"));
        Assert.assertThat((Object)this.builder.buildAgoMessage(this.secondsAgo(10), this.now), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"just now")));
    }

    @Test
    public void buildAgoMessage_LessThanAMinuteAgo() {
        Assert.assertThat((Object)this.builder.buildAgoMessage(10L), (Matcher)Matchers.equalTo((Object)"less than a minute ago"));
        Assert.assertThat((Object)this.builder.buildAgoMessage(59L), (Matcher)Matchers.equalTo((Object)"less than a minute ago"));
        Assert.assertThat((Object)this.builder.buildAgoMessage(60L), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"less than a minute ago")));
    }

    @Test
    public void buildAgoMessage_Minutes() {
        this.checkMessage(1, 60, "about a minute ago");
        this.checkMessage(2, 60, "about 2 minutes ago");
        this.checkMessage(59, 60, "about 59 minutes ago");
    }

    @Test
    public void buildAgoMessage_Hours() {
        this.checkMessage(1, 3600, "about an hour ago");
        this.checkMessage(2, 3600, "about 2 hours ago");
        this.checkMessage(23, 3600, "about 23 hours ago");
    }

    @Test
    public void buildAgoMessage_Days() {
        this.checkMessage(1, 86400, "about a day ago");
        this.checkMessage(2, 86400, "about 2 days ago");
    }

    public void checkMessage(int amount, int unit, String message) {
        Assert.assertThat((Object)this.builder.buildAgoMessage(amount * unit), (Matcher)Matchers.equalTo((Object)message));
        Assert.assertThat((Object)this.builder.buildAgoMessage((amount + 1) * unit - 1), (Matcher)Matchers.equalTo((Object)message));
        Assert.assertThat((Object)this.builder.buildAgoMessage((amount + 1) * unit), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)message)));
    }

    private Date secondsAgo(int amount) {
        return this.millisAgo(amount * 1000);
    }

    private Date millisAgo(int amount) {
        return new Date(this.now.getTime() - (long)amount);
    }
}

