/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.projectusus.ui.internal.Snapshot;

public class SnapshotInfoBuilder {
    public String buildInfo(Snapshot snapshot) {
        Date date = snapshot.getDate();
        return "Snapshot taken at " + this.format(date) + " (" + this.buildAgoMessage(date) + ")";
    }

    protected String buildAgoMessage(Date date) {
        return this.buildAgoMessage(date, new Date());
    }

    protected String buildAgoMessage(Date timeInPast, Date now) {
        return this.buildAgoMessage((now.getTime() - timeInPast.getTime()) / 1000L);
    }

    public String buildAgoMessage(long seconds) {
        StringBuilder result = new StringBuilder();
        this.buildAgoMessageImpl(seconds, result);
        return result.toString();
    }

    private boolean buildAgoMessageImpl(long seconds, StringBuilder result) {
        return this.inDays(seconds, result) || this.inHours(seconds, result) || this.inMinutes(seconds, result) || this.inSeconds(seconds, result);
    }

    private boolean inSeconds(long seconds, StringBuilder result) {
        if (seconds < 0L) {
            result.append("in the future");
        } else if (seconds < 10L) {
            result.append("just now");
        } else {
            result.append("less than a minute ago");
        }
        return true;
    }

    private boolean inMinutes(long seconds, StringBuilder result) {
        return this.inUnit(seconds, 60, "about a minute ago", "about {0} minutes ago", result);
    }

    private boolean inHours(long seconds, StringBuilder result) {
        return this.inUnit(seconds, 3600, "about an hour ago", "about {0} hours ago", result);
    }

    private boolean inDays(long seconds, StringBuilder result) {
        return this.inUnit(seconds, 86400, "about a day ago", "about {0} days ago", result);
    }

    private boolean inUnit(long seconds, int denominator, String singleUnit, String multipleUnits, StringBuilder result) {
        long diff = seconds / (long)denominator;
        if (diff == 1L) {
            result.append(singleUnit);
        } else if (diff > 1L) {
            result.append(MessageFormat.format(multipleUnits, diff));
        }
        return diff > 0L;
    }

    private String format(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }
}

