/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.projectusus.ui.internal.AnalysisDisplayModel;
import org.projectusus.ui.internal.IDisplayModelListener;
import org.projectusus.ui.internal.Snapshot;
import org.projectusus.ui.internal.proportions.actions.OpenHotspots;
import org.projectusus.ui.internal.proportions.actions.RefreshHotspots;
import org.projectusus.ui.internal.proportions.actions.ToggleAutoCompute;
import org.projectusus.ui.internal.proportions.cockpit.CockpitTreeViewer;
import org.projectusus.ui.internal.proportions.cockpit.CockpitVisibilityListener;
import org.projectusus.ui.internal.proportions.cockpit.ISnapshotView;
import org.projectusus.ui.internal.proportions.cockpit.SnapshotInfoUpdater;
import org.projectusus.ui.internal.selection.ExtractCodeProportion;

public class CockpitView
extends ViewPart
implements ISnapshotView {
    private CockpitTreeViewer treeViewer;
    private IDisplayModelListener listener;
    private SnapshotInfoUpdater updater;
    private final CockpitVisibilityListener visibilityListener = new CockpitVisibilityListener(this);

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.initOpenBehavior();
        this.initActionBars();
        this.initContextMenuBehavior();
        this.initModelListener();
        this.initSnapshotInfoUpdater();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.getSite().getPage().addPartListener((IPartListener2)this.visibilityListener);
    }

    private void initSnapshotInfoUpdater() {
        this.updater = new SnapshotInfoUpdater(this);
        this.updater.start();
    }

    @Override
    public void updateSnapshotInfo(String info) {
        this.setContentDescription(info);
    }

    public void setFocus() {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        this.updater.stop();
        AnalysisDisplayModel.displayModel().removeModelListener(this.listener);
        this.getSite().getPage().removePartListener((IPartListener2)this.visibilityListener);
        super.dispose();
    }

    private void initOpenBehavior() {
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                new OpenHotspots(CockpitView.this.treeViewer.getSelection()).run();
            }
        });
    }

    private void initContextMenuBehavior() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new OpenHotspots(CockpitView.this.treeViewer.getSelection()));
                manager.add((IContributionItem)new Separator());
                CockpitView.this.addContextActionsFor(manager, CockpitView.this.treeViewer.getSelection());
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
    }

    protected void addContextActionsFor(IMenuManager manager, ISelection selection) {
        new ExtractCodeProportion(selection).compute();
    }

    private void initActionBars() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)new ToggleAutoCompute());
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void initModelListener() {
        this.listener = new IDisplayModelListener(){

            @Override
            public void updateCategories(final AnalysisDisplayModel model) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CockpitView.this.handleDisplayModelChanged(model);
                    }
                });
            }

            @Override
            public void snapshotCreated(final Snapshot snapshot) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CockpitView.this.updater.update(snapshot);
                    }
                });
            }
        };
        AnalysisDisplayModel.displayModel().addModelListener(this.listener);
    }

    private void handleDisplayModelChanged(AnalysisDisplayModel model) {
        this.refresh(model);
    }

    private void refresh(AnalysisDisplayModel model) {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            ISelection selection = this.treeViewer.getSelection();
            this.treeViewer.setInput(model);
            this.treeViewer.expandAll();
            if (!selection.isEmpty()) {
                this.treeViewer.selectInTree(((TreeSelection)selection).getFirstElement());
                new RefreshHotspots(model).run();
            }
        }
    }

    private void createViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.treeViewer = new CockpitTreeViewer(parent);
    }
}

