/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.MetricStatisticsCategory;
import org.projectusus.ui.internal.proportions.cockpit.CockpitCP;
import org.projectusus.ui.internal.proportions.cockpit.CockpitColumnDesc;
import org.projectusus.ui.internal.proportions.cockpit.CockpitLP;
import org.projectusus.ui.viewer.UsusTreeViewer;

class CockpitTreeViewer
extends UsusTreeViewer<AnalysisDisplayEntry> {
    CockpitTreeViewer(Composite parent) {
        super(parent, CockpitColumnDesc.values());
        this.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.setLabelProvider((IBaseLabelProvider)new CockpitLP());
        this.setContentProvider((IContentProvider)new CockpitCP());
    }

    void selectInTree(Object object) {
        if (object instanceof AnalysisDisplayEntry) {
            this.selectCodeProportionInTree((AnalysisDisplayEntry)object);
        }
    }

    private void selectCodeProportionInTree(AnalysisDisplayEntry displayEntry) {
        Object[] objectArray = this.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof MetricStatisticsCategory) {
                AnalysisDisplayEntry[] analysisDisplayEntryArray = ((MetricStatisticsCategory)element).getChildren();
                int n3 = analysisDisplayEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    AnalysisDisplayEntry entry = analysisDisplayEntryArray[n4];
                    if (entry.isSameKindAs(displayEntry)) {
                        this.setSelection((ISelection)this.createTreeSelection(element, entry));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private TreeSelection createTreeSelection(Object ... elements) {
        return new TreeSelection(new TreePath(elements));
    }
}

