/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.cockpit;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;
import org.projectusus.ui.colors.ISharedUsusImages;
import org.projectusus.ui.colors.UsusUIImages;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.viewer.IColumnDesc;

enum CockpitColumnDesc implements IColumnDesc<AnalysisDisplayEntry>
{
    Indicator(true){

        @Override
        public String getLabel(AnalysisDisplayEntry element) {
            return element.getLabel();
        }
    }
    ,
    Average(false){

        @Override
        public String getLabel(AnalysisDisplayEntry element) {
            return formatter.format(element.getAverage());
        }
    }
    ,
    Violations(false){

        @Override
        public String getLabel(AnalysisDisplayEntry element) {
            return String.valueOf(element.getViolations());
        }
    }
    ,
    Total(false){

        @Override
        public String getLabel(AnalysisDisplayEntry element) {
            return element.getBasis();
        }
    }
    ,
    Trend(true){

        @Override
        public String getLabel(AnalysisDisplayEntry element) {
            return "";
        }

        @Override
        public Image getImage(AnalysisDisplayEntry element) {
            return element.getTrendImage();
        }
    };

    private final boolean hasImage;
    private static final DecimalFormat formatter;

    static {
        formatter = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    }

    private CockpitColumnDesc(boolean hasImage) {
        this.hasImage = hasImage;
    }

    @Override
    public boolean hasImage() {
        return this.hasImage;
    }

    public Image getImage(AnalysisDisplayEntry element) {
        return UsusUIImages.getSharedImages().getImage(ISharedUsusImages.OBJ_INFO);
    }

    /* synthetic */ CockpitColumnDesc(String string, int n, boolean bl, CockpitColumnDesc cockpitColumnDesc) {
        this(bl);
    }
}

