/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.proportions.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.UsusUIPlugin;
import org.projectusus.ui.internal.hotspots.HotSpotsView;

public class OpenHotspots
extends Action {
    private final ISelection selection;

    public OpenHotspots(ISelection selection) {
        super("Open Hotspots");
        this.selection = selection;
    }

    public boolean isEnabled() {
        boolean result = false;
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            result = ssel.getFirstElement() instanceof AnalysisDisplayEntry;
        }
        return result;
    }

    public void run() {
        Object element;
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (element = ((IStructuredSelection)this.selection).getFirstElement()) instanceof AnalysisDisplayEntry) {
            this.showHotspotsView((AnalysisDisplayEntry)element);
        }
    }

    private void showHotspotsView(AnalysisDisplayEntry entry) {
        try {
            IViewPart viewPart = this.getPage().showView(HotSpotsView.class.getName());
            if (viewPart instanceof HotSpotsView) {
                ((HotSpotsView)viewPart).update(entry);
            }
        }
        catch (PartInitException paix) {
            UsusUIPlugin.getDefault().getLog().log(paix.getStatus());
        }
    }

    private IWorkbenchPage getPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

