/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.perspective;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.projectusus.ui.internal.coveredprojects.CoveredProjectsView;
import org.projectusus.ui.internal.histogram.HistogramView;
import org.projectusus.ui.internal.hotspots.HotSpotsView;
import org.projectusus.ui.internal.proportions.cockpit.CockpitView;
import org.projectusus.ui.internal.yellowcount.YellowCountView;

public class USUSPerspective
implements IPerspectiveFactory {
    private static final List<String> INTERESTING_THIRD_PARTY_VIEWS = USUSPerspective.collectInterestingViews();
    private static final List<String> INTERESTING_THIRD_PARTY_WIZARDS = USUSPerspective.collectInterestingNewWizards();

    public void createInitialLayout(IPageLayout layout) {
        this.layoutViews(layout);
        this.createViewShortcuts(layout);
        this.createPerspectiveShortcuts(layout);
        this.createNewWizardShortcuts(layout);
    }

    private void layoutViews(IPageLayout layout) {
        IFolderLayout projects = layout.createFolder("projects", 1, 0.4f, layout.getEditorArea());
        projects.addView("org.eclipse.jdt.ui.PackageExplorer");
        projects.addView(CoveredProjectsView.class.getName());
        layout.addView(CockpitView.class.getName(), 4, 0.5f, "projects");
        layout.addView(YellowCountView.class.getName(), 4, 0.8f, CockpitView.class.getName());
        IFolderLayout analysis = layout.createFolder("analysis", 4, 0.33f, layout.getEditorArea());
        analysis.addView(HotSpotsView.class.getName());
        analysis.addView(HistogramView.class.getName());
        for (String viewId : INTERESTING_THIRD_PARTY_VIEWS) {
            analysis.addView(viewId);
        }
    }

    private void createViewShortcuts(IPageLayout layout) {
        layout.addShowViewShortcut(CockpitView.class.getName());
        layout.addShowViewShortcut(HotSpotsView.class.getName());
        layout.addShowViewShortcut(YellowCountView.class.getName());
        layout.addShowViewShortcut(CoveredProjectsView.class.getName());
        for (String viewId : INTERESTING_THIRD_PARTY_VIEWS) {
            layout.addShowViewShortcut(viewId);
        }
        layout.addShowViewShortcut("org.eclipse.jdt.ui.PackageExplorer");
    }

    private void createPerspectiveShortcuts(IPageLayout layout) {
        layout.addPerspectiveShortcut("org.eclipse.jdt.ui.JavaPerspective");
        layout.addPerspectiveShortcut("org.eclipse.pde.ui.PDEPerspective");
    }

    private static List<String> collectInterestingViews() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("org.eclipse.ui.views.TaskList");
        result.add("org.eclipse.ui.views.ProblemView");
        result.add("org.eclipse.jdt.junit.ResultView");
        return result;
    }

    private void createNewWizardShortcuts(IPageLayout layout) {
        for (String wizardId : INTERESTING_THIRD_PARTY_WIZARDS) {
            layout.addNewWizardShortcut(wizardId);
        }
    }

    private static List<String> collectInterestingNewWizards() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("org.eclipse.jdt.ui.wizards.JavaProjectWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewPackageCreationWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewClassCreationWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewSourceFolderCreationWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewEnumCreationWizard");
        result.add("org.eclipse.jdt.ui.wizards.NewAnnotationCreationWizard");
        return result;
    }
}

