/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.hotspots.selectionprovider;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.projectusus.ui.internal.hotspots.selectionprovider.NullSelectionProvider;

public class DelegatingSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private final Set<ISelectionChangedListener> listeners = new LinkedHashSet<ISelectionChangedListener>();
    private ISelectionProvider delegate = new NullSelectionProvider();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void switchTo(ISelectionProvider newDelegate) {
        this.delegate.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.delegate = newDelegate;
        this.delegate.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fireSelectionChanged();
    }

    public ISelection getSelection() {
        return this.delegate.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.delegate.setSelection(selection);
    }

    private void fireSelectionChanged() {
        this.fireSelectionChanged(this.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }
}

