/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.hotspots.pages;

import java.util.Arrays;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.services.IServiceLocator;
import org.projectusus.core.util.Defect;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.DisplayHotspot;
import org.projectusus.ui.internal.hotspots.pages.HotspotsCP;
import org.projectusus.ui.internal.hotspots.pages.HotspotsColumnDesc;
import org.projectusus.ui.internal.hotspots.pages.HotspotsLP;
import org.projectusus.ui.internal.hotspots.pages.IHotspotsPage;
import org.projectusus.ui.viewer.UsusTreeViewer;

public class HotspotsPage
extends Page
implements IHotspotsPage {
    private final IServiceLocator serviceLocator;
    private final AnalysisDisplayEntry entry;
    private UsusTreeViewer<DisplayHotspot<?>> viewer;
    private ViewerComparator comparator;

    public HotspotsPage(IServiceLocator serviceLocator, AnalysisDisplayEntry entry) {
        this.serviceLocator = serviceLocator;
        this.entry = entry;
    }

    @Override
    public boolean isInitialized() {
        return this.viewer != null;
    }

    protected IStructuredContentProvider createContentProvider() {
        return new HotspotsCP();
    }

    private void createViewer(Composite parent) {
        HotspotsColumnDesc[] columnDescs = HotspotsColumnDesc.getColumnDescs(this.entry.getLocationType());
        this.viewer = new UsusTreeViewer(parent, columnDescs);
        this.viewer.setLabelProvider((IBaseLabelProvider)new HotspotsLP(Arrays.asList(columnDescs)));
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.comparator = new ViewerComparator(){

            public int compare(Viewer viewer1, Object e1, Object e2) {
                return ((DisplayHotspot)e1).compareTo((DisplayHotspot)e2);
            }
        };
        this.viewer.setComparator(this.comparator);
    }

    protected void initOpenListener() {
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IHandlerService handlerService = (IHandlerService)HotspotsPage.this.serviceLocator.getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("org.projectusus.ui.commands.OpenHotspot", null);
                }
                catch (NotHandledException notHandledException) {
                }
                catch (Exception exception) {
                    throw new Defect((Throwable)exception);
                }
            }
        });
    }

    @Override
    public void setInput(AnalysisDisplayEntry entry) {
        Object selectedDisplayHotspot;
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        this.viewer.setInput(entry);
        if (!selection.isEmpty() && (selectedDisplayHotspot = selection.getFirstElement()) instanceof DisplayHotspot) {
            this.selectCodeProportionInTree((DisplayHotspot)selectedDisplayHotspot);
        }
    }

    public void createControl(Composite parent) {
        this.createViewer(parent);
        this.initOpenListener();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    @Override
    public void refresh() {
        this.setInput(this.entry);
    }

    @Override
    public boolean matches(AnalysisDisplayEntry otherEntry) {
        return this.entry.isSameKindAs(otherEntry);
    }

    @Override
    public void resetSort() {
        this.viewer.setComparator(this.comparator);
        this.viewer.resetColumnSorting();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    @Override
    public String getDescription() {
        return this.entry.getDescription();
    }

    private void selectCodeProportionInTree(DisplayHotspot<?> hotspot) {
        for (DisplayHotspot<?> currrent : this.entry.getHotspots()) {
            if (!currrent.getCurrentOrOldHotspot().equals(hotspot.getCurrentOrOldHotspot())) continue;
            this.viewer.setSelection((ISelection)this.createTreeSelection(currrent));
            return;
        }
    }

    private TreeSelection createTreeSelection(Object ... elements) {
        return new TreeSelection(new TreePath(elements));
    }
}

