/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.hotspots.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.ui.internal.DisplayHotspot;
import org.projectusus.ui.internal.hotspots.commands.AbstractOpenHotspotHandler;
import org.projectusus.ui.util.EditorOpener;

public class OpenHotspotInEditor
extends AbstractOpenHotspotHandler<FileHotspot> {
    @Override
    protected void open(List<DisplayHotspot<FileHotspot>> hotspots) throws ExecutionException {
        for (DisplayHotspot<FileHotspot> hotspot : hotspots) {
            this.open(hotspot);
        }
    }

    private void open(DisplayHotspot<FileHotspot> hotspot) {
        FileHotspot realHotspot = hotspot.getHotspot();
        ICompilationUnit compilationUnit = this.extractCompilationUnit(hotspot);
        EditorOpener opener = new EditorOpener();
        if (realHotspot == null || compilationUnit == null) {
            opener.openEditor(hotspot.getFile());
        } else {
            opener.openEditorAt(compilationUnit, realHotspot.getSourcePosition());
        }
    }

    private ICompilationUnit extractCompilationUnit(DisplayHotspot<FileHotspot> hotspot) {
        try {
            return JavaCore.createCompilationUnitFrom((IFile)hotspot.getFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

