/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.hotspots;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.hotspots.pages.DefaultHotspotsPage;
import org.projectusus.ui.internal.hotspots.pages.HotspotsPage;
import org.projectusus.ui.internal.hotspots.pages.IHotspotsPage;
import org.projectusus.ui.internal.hotspots.selectionprovider.DelegatingSelectionProvider;

public class HotSpotsView
extends ViewPart {
    private PageBook book;
    private IHotspotsPage defaultPage;
    private IHotspotsPage activePage;
    private final Set<IHotspotsPage> pages = new HashSet<IHotspotsPage>();
    private final DelegatingSelectionProvider selectionProvider = new DelegatingSelectionProvider();

    public void update(AnalysisDisplayEntry entry) {
        if (entry != null) {
            this.updatePage(entry);
        }
    }

    public void createPartControl(Composite parent) {
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.book = new PageBook(parent, 0);
        this.defaultPage = new DefaultHotspotsPage();
        this.defaultPage.createControl((Composite)this.book);
        this.showPage(this.defaultPage);
    }

    public void setFocus() {
        if (this.book != null) {
            this.book.setFocus();
        }
        if (this.activePage != null) {
            this.activePage.setFocus();
        }
    }

    public void dispose() {
        this.activePage = null;
        if (this.defaultPage != null) {
            this.defaultPage.dispose();
        }
        super.dispose();
    }

    private void showPage(IHotspotsPage page) {
        if (this.activePage == page) {
            return;
        }
        this.activePage = page;
        Control pageControl = this.activePage.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.setContentDescription(page.getDescription());
            this.selectionProvider.switchTo(page.getSelectionProvider());
            this.book.showPage(pageControl);
        }
    }

    private IHotspotsPage createPage(AnalysisDisplayEntry entry) {
        IHotspotsPage page = this.getPageFor(entry);
        if (page != null && !page.isInitialized()) {
            page.createControl((Composite)this.book);
        }
        return page;
    }

    private IHotspotsPage getPageFor(AnalysisDisplayEntry entry) {
        IHotspotsPage page2;
        if (!entry.hasHotspots()) {
            return null;
        }
        for (IHotspotsPage page2 : this.pages) {
            if (!page2.matches(entry)) continue;
            return page2;
        }
        page2 = new HotspotsPage((IServiceLocator)this.getSite(), entry);
        this.pages.add(page2);
        return page2;
    }

    private void updatePage(AnalysisDisplayEntry entry) {
        IHotspotsPage page = this.createPage(entry);
        if (page != null) {
            page.setInput(entry);
            this.showPage(page);
        } else {
            this.showPage(this.defaultPage);
        }
    }

    public void refreshActivePage(List<AnalysisDisplayEntry> entries) {
        for (AnalysisDisplayEntry entry : entries) {
            if (this.activePage == null || !this.activePage.matches(entry)) continue;
            this.activePage.setInput(entry);
        }
    }

    public void resetSort() {
        this.activePage.resetSort();
    }
}

