/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.histogram;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.part.ViewPart;
import org.projectusus.ui.colors.UsusColors;
import org.projectusus.ui.internal.AnalysisDisplayModel;
import org.projectusus.ui.internal.histogram.ChartUpdater;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.ext.InteractiveChart;

public class HistogramView
extends ViewPart {
    static final String SERIES_ID = "histogram";
    private Chart chart;
    private ChartUpdater updater;

    public void createPartControl(Composite parent) {
        this.chart = new InteractiveChart(parent, 0);
        this.updater = new ChartUpdater(this.chart);
        this.initializeChart();
        this.hookListeners();
    }

    public void setFocus() {
        this.chart.setFocus();
    }

    public void dispose() {
        this.unhookListeners();
        super.dispose();
    }

    private void initializeChart() {
        ILineSeries series = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, SERIES_ID);
        series.setLineStyle(LineStyle.NONE);
        series.setSymbolColor(UsusColors.getSharedColors().getColor("USUS_LIGHT_BLUE"));
        this.chart.getTitle().setVisible(false);
        this.chart.getLegend().setVisible(false);
        this.chart.setBackground(Display.getCurrent().getSystemColor(1));
        this.chart.setBackgroundInPlotArea(Display.getCurrent().getSystemColor(1));
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText("Count");
        yAxis.getTitle().setForeground(Display.getCurrent().getSystemColor(2));
        yAxis.getTick().setForeground(Display.getCurrent().getSystemColor(16));
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setForeground(Display.getCurrent().getSystemColor(2));
        xAxis.getTick().setForeground(Display.getCurrent().getSystemColor(16));
    }

    private void hookListeners() {
        AnalysisDisplayModel.displayModel().addModelListener(this.updater);
        this.getSelectionService().addSelectionListener((ISelectionListener)this.updater);
    }

    private void unhookListeners() {
        this.getSelectionService().removeSelectionListener((ISelectionListener)this.updater);
        AnalysisDisplayModel.displayModel().removeModelListener(this.updater);
    }

    private ISelectionService getSelectionService() {
        return (ISelectionService)this.getSite().getService(ISelectionService.class);
    }
}

