/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.histogram;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.projectusus.core.basis.Histogram;
import org.projectusus.jfeet.selection.ElementFrom;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.AnalysisDisplayModel;
import org.projectusus.ui.internal.IDisplayCategory;
import org.projectusus.ui.internal.IDisplayModelListener;
import org.projectusus.ui.internal.Snapshot;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

class ChartUpdater
implements ISelectionListener,
IDisplayModelListener {
    private final Chart chart;
    private AnalysisDisplayEntry lastEntry;

    public ChartUpdater(Chart chart) {
        this.chart = chart;
    }

    void updateChart(AnalysisDisplayModel newModel) {
        if (this.lastEntry == null) {
            return;
        }
        IDisplayCategory[] iDisplayCategoryArray = newModel.getCategories();
        int n = iDisplayCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplayCategory category = iDisplayCategoryArray[n2];
            AnalysisDisplayEntry[] analysisDisplayEntryArray = category.getChildren();
            int n3 = analysisDisplayEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AnalysisDisplayEntry entry = analysisDisplayEntryArray[n4];
                if (entry.isSameKindAs(this.lastEntry)) {
                    this.updateChart(entry);
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    void updateChart(final AnalysisDisplayEntry entry) {
        this.lastEntry = entry;
        this.chart.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IAxis xAxis = ChartUpdater.this.chart.getAxisSet().getXAxis(0);
                xAxis.getTitle().setText(entry.getLabel());
                ISeries series = ChartUpdater.this.chart.getSeriesSet().getSeries("histogram");
                Histogram histogram = entry.getHistogram();
                series.setXSeries(histogram.allNumbers());
                series.setYSeries(histogram.allValues());
                ChartUpdater.this.chart.getAxisSet().adjustRange();
                ChartUpdater.this.chart.redraw();
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        AnalysisDisplayEntry entry = (AnalysisDisplayEntry)new ElementFrom(selection).as(AnalysisDisplayEntry.class);
        if (entry != null) {
            this.updateChart(entry);
        }
    }

    @Override
    public void updateCategories(AnalysisDisplayModel newModel) {
        this.updateChart(newModel);
    }

    @Override
    public void snapshotCreated(Snapshot snapshot) {
    }
}

