/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.coveredprojects;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.projectusus.jfeet.selection.ElementsFrom;
import org.projectusus.ui.internal.UsusUIPlugin;
import org.projectusus.ui.internal.coveredprojects.CoveredProjectsView;
import org.projectusus.ui.internal.coveredprojects.UsusProjectMarker;

class SetUsusProjectOnSelection
extends Action {
    private final CoveredProjectsView coveredProjectsView;
    private final ISelection selection;
    private boolean checked;

    static IAction checkSelected(CoveredProjectsView coveredProjectsView, ISelection selection) {
        SetUsusProjectOnSelection setUsus = new SetUsusProjectOnSelection(coveredProjectsView, selection);
        setUsus.checked = true;
        setUsus.setText("Add to Usus projects");
        setUsus.setImageDescriptor(UsusUIPlugin.getImageDescriptor("icons/full/elcl16/check.gif"));
        return setUsus;
    }

    static IAction uncheckSelected(CoveredProjectsView coveredProjectsView, ISelection selection) {
        SetUsusProjectOnSelection setUsus = new SetUsusProjectOnSelection(coveredProjectsView, selection);
        setUsus.checked = false;
        setUsus.setText("Remove from Usus projects");
        setUsus.setImageDescriptor(UsusUIPlugin.getImageDescriptor("icons/full/elcl16/uncheck.gif"));
        return setUsus;
    }

    private SetUsusProjectOnSelection(CoveredProjectsView coveredProjectsView, ISelection selection) {
        this.coveredProjectsView = coveredProjectsView;
        this.selection = selection;
        this.updateEnablement();
    }

    public void run() {
        this.markProjects(this.getSelectedProjects());
        this.coveredProjectsView.refresh();
    }

    private void markProjects(List<IProject> selectedProjects) {
        UsusProjectMarker marker = new UsusProjectMarker();
        if (this.checked) {
            marker.check(selectedProjects);
        } else {
            marker.uncheck(selectedProjects);
        }
    }

    private void updateEnablement() {
        this.setEnabled(!this.getSelectedProjects().isEmpty());
    }

    private List<IProject> getSelectedProjects() {
        return new ElementsFrom(this.selection).as(IProject.class);
    }
}

