/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal.coveredprojects;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.projectusus.core.project.FindUsusProjects;
import org.projectusus.ui.internal.coveredprojects.ColumnDesc;
import org.projectusus.ui.internal.coveredprojects.CoveredProjectsCP;
import org.projectusus.ui.internal.coveredprojects.CoveredProjectsLP;
import org.projectusus.ui.internal.coveredprojects.SetUsusProjectOnSelection;
import org.projectusus.ui.internal.coveredprojects.UsusProjectMarker;

public class CoveredProjectsView
extends ViewPart {
    private CheckboxTableViewer viewer;

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.configureActionBars();
        this.refresh();
    }

    public void setFocus() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    private void createViewer(Composite parent) {
        Table table = this.createTable(parent);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new CoveredProjectsCP());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CoveredProjectsLP());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CoveredProjectsView.this.updateUsusProject(event.getElement(), event.getChecked());
                CoveredProjectsView.this.refresh();
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(this.createContextMenu());
        table.setMenu(menuManager.createContextMenu((Control)parent));
    }

    private IMenuListener createContextMenu() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                manager.add(SetUsusProjectOnSelection.checkSelected(CoveredProjectsView.this, CoveredProjectsView.this.viewer.getSelection()));
                manager.add(SetUsusProjectOnSelection.uncheckSelected(CoveredProjectsView.this, CoveredProjectsView.this.viewer.getSelection()));
            }
        };
    }

    private void updateUsusProject(Object element, boolean checked) {
        if (element instanceof IProject) {
            UsusProjectMarker marker = new UsusProjectMarker();
            IProject project = (IProject)element;
            if (checked) {
                marker.check(project);
            } else {
                marker.uncheck(project);
            }
        }
    }

    private Table createTable(Composite parent) {
        Composite comp = new Composite(parent, 0);
        int style = 66082;
        Table result = new Table(comp, style);
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        result.setLinesVisible(false);
        result.setHeaderVisible(false);
        this.createColumns(result, layout);
        return result;
    }

    private void createColumns(Table table, TableColumnLayout layout) {
        ColumnDesc[] columnDescArray = ColumnDesc.values();
        int n = columnDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDesc columnDesc = columnDescArray[n2];
            TableColumn column = new TableColumn(table, 0);
            ColumnWeightData data = new ColumnWeightData(columnDesc.getWeight());
            layout.setColumnData((Widget)column, (ColumnLayoutData)data);
            ++n2;
        }
    }

    private void configureActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.enableContributions((IContributionManager)bars.getToolBarManager());
        this.enableContributions((IContributionManager)bars.getMenuManager());
    }

    private void enableContributions(IContributionManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    void refresh() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.viewer.setInput((Object)input);
        this.applyCheckedState(input);
    }

    private void applyCheckedState(IWorkspaceRoot input) {
        IContentProvider cp = this.viewer.getContentProvider();
        Object[] elements = ((IStructuredContentProvider)cp).getElements((Object)input);
        List ususProjects = new FindUsusProjects(elements).compute();
        this.viewer.setCheckedElements(ususProjects.toArray());
    }
}

