/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.ui.internal.FileDisplayHotspot;

public class TestSortingOfDisplayHotspots {
    @Test
    public void trendForConstantHotspot() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 3);
        Assert.assertEquals((long)0L, (long)hotspots.get(0).getTrend());
    }

    @Test
    public void trendForImprovedHotspot() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(6, 3);
        Assert.assertEquals((long)-3L, (long)hotspots.get(0).getTrend());
    }

    @Test
    public void trendForWorsenedHotspot() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 7);
        Assert.assertEquals((long)4L, (long)hotspots.get(0).getTrend());
    }

    @Test
    public void twoUnchangedHotspots_largerValueIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 3, 5, 5);
        Collections.sort(hotspots);
        Assert.assertEquals((long)5L, (long)hotspots.get(0).currentMetricsValue());
        Assert.assertEquals((long)3L, (long)hotspots.get(1).currentMetricsValue());
        Assert.assertEquals((long)0L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)0L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoWorsenedHotspots_largerValueIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(1, 4, 5, 6);
        Collections.sort(hotspots);
        Assert.assertEquals((long)6L, (long)hotspots.get(0).currentMetricsValue());
        Assert.assertEquals((long)4L, (long)hotspots.get(1).currentMetricsValue());
        Assert.assertEquals((long)1L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)3L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoImprovedHotspots_largerValueIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 2, 9, 4);
        Collections.sort(hotspots);
        Assert.assertEquals((long)4L, (long)hotspots.get(0).currentMetricsValue());
        Assert.assertEquals((long)2L, (long)hotspots.get(1).currentMetricsValue());
        Assert.assertEquals((long)-5L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)-1L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void improvedAndWorsenedHotspots_largerValueIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 2, 2, 6);
        Collections.sort(hotspots);
        Assert.assertEquals((long)6L, (long)hotspots.get(0).currentMetricsValue());
        Assert.assertEquals((long)2L, (long)hotspots.get(1).currentMetricsValue());
        Assert.assertEquals((long)4L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)-1L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void worsenedAndImprovedHotspots_largerValueIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(3, 4, 6, 5);
        Collections.sort(hotspots);
        Assert.assertEquals((long)5L, (long)hotspots.get(0).currentMetricsValue());
        Assert.assertEquals((long)4L, (long)hotspots.get(1).currentMetricsValue());
        Assert.assertEquals((long)-1L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)1L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoEqualHotspots_OneImproved_largerTrendIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(4, 4, 5, 4);
        Collections.sort(hotspots);
        Assert.assertEquals((long)0L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)-1L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoEqualHotspots_OneWorsened_largerTrendIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(4, 4, 3, 4);
        Collections.sort(hotspots);
        Assert.assertEquals((long)1L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)0L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoEqualHotspots_OneImprovedOneWorsened_largerTrendIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(5, 4, 3, 4);
        Collections.sort(hotspots);
        Assert.assertEquals((long)1L, (long)hotspots.get(0).getTrend());
        Assert.assertEquals((long)-1L, (long)hotspots.get(1).getTrend());
    }

    @Test
    public void twoEqualHotspots_SameTrend_smallerNameIsFirst() {
        List<FileDisplayHotspot> hotspots = this.createHotspotList(5, 4, 5, 4);
        Collections.sort(hotspots);
        Assert.assertEquals((Object)"hotspot0", (Object)hotspots.get(0).getName());
        Assert.assertEquals((Object)"hotspot2", (Object)hotspots.get(1).getName());
    }

    private List<FileDisplayHotspot> createHotspotList(int ... oldAndNewPairs) {
        ArrayList<FileDisplayHotspot> result = new ArrayList<FileDisplayHotspot>();
        int i = 0;
        while (i < oldAndNewPairs.length - 1) {
            SourceCodeLocation location = new SourceCodeLocation("hotspot" + i, 0, 0);
            FileHotspot oldHotspot = new FileHotspot(location, oldAndNewPairs[i], null);
            FileHotspot newHotspot = new FileHotspot(location, oldAndNewPairs[i + 1], null);
            result.add(new FileDisplayHotspot(oldHotspot, newHotspot));
            i += 2;
        }
        return result;
    }
}

