/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.ui.internal.DisplayHotspot;
import org.projectusus.ui.internal.DisplayHotspotCreator;

public class DisplayHotspotCreatorTest {
    private List<Hotspot> oldHotspots;
    private List<Hotspot> currentHotspots;
    private final SourceCodeLocation location1 = new SourceCodeLocation("x", 1, 1);
    private final SourceCodeLocation location2 = new SourceCodeLocation("y", 2, 2);
    private final SourceCodeLocation location3 = new SourceCodeLocation("z", 3, 3);
    private final IFile file1 = (IFile)Mockito.mock(IFile.class);
    private final Hotspot hotspot1_1_1 = new FileHotspot(this.location1, 1, this.file1);
    private final Hotspot hotspot1_2_1 = new FileHotspot(this.location1, 2, this.file1);
    private final Hotspot hotspot2_1_1 = new FileHotspot(this.location2, 1, this.file1);
    private final Hotspot hotspot2_2_1 = new FileHotspot(this.location2, 2, this.file1);
    private final Hotspot hotspot3_1_1 = new FileHotspot(this.location3, 1, this.file1);

    @Before
    public void setup() {
        this.oldHotspots = new ArrayList<Hotspot>();
        this.currentHotspots = new ArrayList<Hotspot>();
    }

    @Test
    public void emptyLists() {
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void oneOld() {
        this.oldHotspots.add(this.hotspot1_2_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)1L, (long)result.size());
        this.checkContains(result, this.hotspot1_2_1, null);
        Assert.assertEquals((long)-2L, (long)result.get(0).getTrend());
    }

    @Test
    public void oneNew() {
        this.currentHotspots.add(this.hotspot1_2_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)1L, (long)result.size());
        this.checkContains(result, null, this.hotspot1_2_1);
        Assert.assertEquals((long)2L, (long)result.get(0).getTrend());
    }

    @Test
    public void oldAndNewIdentical() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.currentHotspots.add(this.hotspot1_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)1L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, this.hotspot1_1_1);
        Assert.assertEquals((long)0L, (long)result.get(0).getTrend());
    }

    @Test
    public void oldBetterThanNew() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.currentHotspots.add(this.hotspot1_2_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)1L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, this.hotspot1_2_1);
        Assert.assertEquals((long)1L, (long)result.get(0).getTrend());
    }

    @Test
    public void oldWorseThanNew() {
        this.oldHotspots.add(this.hotspot1_2_1);
        this.currentHotspots.add(this.hotspot1_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)1L, (long)result.size());
        this.checkContains(result, this.hotspot1_2_1, this.hotspot1_1_1);
        Assert.assertEquals((long)-1L, (long)result.get(0).getTrend());
    }

    @Test
    public void oldAndNewDifferentLocations() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.currentHotspots.add(this.hotspot2_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)2L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, null);
        this.checkContains(result, null, this.hotspot2_1_1);
        Assert.assertEquals((long)1L, (long)result.get(0).getTrend());
        Assert.assertEquals((long)-1L, (long)result.get(1).getTrend());
    }

    @Test
    public void oldAndNewOneDifferentOneSame() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.oldHotspots.add(this.hotspot2_1_1);
        this.currentHotspots.add(this.hotspot2_1_1);
        this.currentHotspots.add(this.hotspot3_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)3L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, null);
        this.checkContains(result, this.hotspot2_1_1, this.hotspot2_1_1);
        this.checkContains(result, null, this.hotspot3_1_1);
        Assert.assertEquals((long)1L, (long)result.get(0).getTrend());
        Assert.assertEquals((long)0L, (long)result.get(1).getTrend());
        Assert.assertEquals((long)-1L, (long)result.get(2).getTrend());
    }

    @Test
    public void oldAndNewOneDifferentOneDifferentValue() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.oldHotspots.add(this.hotspot2_1_1);
        this.currentHotspots.add(this.hotspot2_2_1);
        this.currentHotspots.add(this.hotspot3_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)3L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, null);
        this.checkContains(result, this.hotspot2_1_1, this.hotspot2_2_1);
        this.checkContains(result, null, this.hotspot3_1_1);
        Assert.assertEquals((long)1L, (long)result.get(0).getTrend());
        Assert.assertEquals((long)1L, (long)result.get(1).getTrend());
        Assert.assertEquals((long)-1L, (long)result.get(2).getTrend());
    }

    @Test
    public void oldAndNewOneDifferentTwoSame() {
        this.oldHotspots.add(this.hotspot1_1_1);
        this.oldHotspots.add(this.hotspot2_1_1);
        this.oldHotspots.add(this.hotspot3_1_1);
        this.currentHotspots.add(this.hotspot1_1_1);
        this.currentHotspots.add(this.hotspot2_2_1);
        this.currentHotspots.add(this.hotspot3_1_1);
        List<DisplayHotspot<?>> result = this.createDisplay(this.oldHotspots, this.currentHotspots);
        Assert.assertEquals((long)3L, (long)result.size());
        this.checkContains(result, this.hotspot1_1_1, this.hotspot1_1_1);
        this.checkContains(result, this.hotspot2_1_1, this.hotspot2_2_1);
        this.checkContains(result, this.hotspot3_1_1, this.hotspot3_1_1);
        Assert.assertEquals((long)1L, (long)result.get(0).getTrend());
        Assert.assertEquals((long)0L, (long)result.get(1).getTrend());
        Assert.assertEquals((long)0L, (long)result.get(2).getTrend());
    }

    private void checkContains(List<DisplayHotspot<?>> result, Hotspot oldHotspot, Hotspot newHotspot) {
        for (DisplayHotspot<?> displayHotspot : result) {
            if (!this.compare(oldHotspot, (Hotspot)displayHotspot.getOldHotspot()) || !this.compare(newHotspot, (Hotspot)displayHotspot.getHotspot()) || !this.compareMetricsValue(newHotspot, displayHotspot)) continue;
            return;
        }
        Assert.fail((String)"List does not contain any elements matching the conditions.");
    }

    private boolean compareMetricsValue(Hotspot newHotspot, DisplayHotspot<?> displayHotspot) {
        return newHotspot == null && displayHotspot.getMetricsValue() == 0 || newHotspot != null && newHotspot.getMetricsValue() == displayHotspot.getMetricsValue();
    }

    private boolean compare(Hotspot expected, Hotspot actual) {
        return expected == null && actual == null || expected != null && expected.equals(actual);
    }

    private List<DisplayHotspot<?>> createDisplay(List<Hotspot> oldHots, List<Hotspot> currentHots) {
        return new DisplayHotspotCreator(oldHots, currentHots).hotspots();
    }
}

