/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.PackageHotspot;
import org.projectusus.core.basis.SinglePackageHotspot;
import org.projectusus.ui.internal.DisplayHotspot;
import org.projectusus.ui.internal.FileDisplayHotspot;
import org.projectusus.ui.internal.PackageDisplayHotspot;
import org.projectusus.ui.internal.SinglePackageDisplayHotspot;

class DisplayHotspotCreator {
    private final Set<Hotspot> oldHotspots;
    private final Set<Hotspot> currentHotspots;

    public DisplayHotspotCreator(List<Hotspot> oldHotspots, List<Hotspot> currentHotspots) {
        this.oldHotspots = new HashSet<Hotspot>(oldHotspots);
        this.currentHotspots = new HashSet<Hotspot>(currentHotspots);
    }

    public List<DisplayHotspot<?>> hotspots() {
        HashSet result = new HashSet();
        Sets.SetView oldNotInNew = Sets.difference(this.oldHotspots, this.currentHotspots);
        for (Hotspot hotspot : oldNotInNew) {
            result.add(this.createDisplayHotspot(hotspot, null));
        }
        Sets.SetView newNotInOld = Sets.difference(this.currentHotspots, this.oldHotspots);
        for (Hotspot hotspot : newNotInOld) {
            result.add(this.createDisplayHotspot(null, hotspot));
        }
        Sets.SetView oldAlsoInNew = Sets.difference(this.oldHotspots, (Set)oldNotInNew);
        Sets.SetView newAlsoInOld = Sets.difference(this.currentHotspots, (Set)newNotInOld);
        ArrayList oldInNewSorted = new ArrayList(oldAlsoInNew);
        ArrayList newInOldSorted = new ArrayList(newAlsoInOld);
        Collections.sort(oldInNewSorted);
        Collections.sort(newInOldSorted);
        int i = 0;
        while (i < oldInNewSorted.size()) {
            Hotspot oldHotspot = (Hotspot)oldInNewSorted.get(i);
            Hotspot newHotspot = (Hotspot)newInOldSorted.get(i);
            if (oldHotspot.getName().equals(newHotspot.getName())) {
                result.add(this.createDisplayHotspot(oldHotspot, newHotspot));
            }
            ++i;
        }
        ArrayList resultList = new ArrayList(result);
        Collections.sort(resultList);
        return resultList;
    }

    private DisplayHotspot<?> createDisplayHotspot(Hotspot oldHotspot, Hotspot newHotspot) {
        if (oldHotspot instanceof FileHotspot || newHotspot instanceof FileHotspot) {
            return new FileDisplayHotspot((FileHotspot)oldHotspot, (FileHotspot)newHotspot);
        }
        if (oldHotspot instanceof SinglePackageHotspot || newHotspot instanceof SinglePackageHotspot) {
            return new SinglePackageDisplayHotspot((SinglePackageHotspot)oldHotspot, (SinglePackageHotspot)newHotspot);
        }
        return new PackageDisplayHotspot((PackageHotspot)oldHotspot, (PackageHotspot)newHotspot);
    }
}

